/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import java.util.Locale;
import java.util.Objects;

@Experimental(eta="2022-10-31")
public final class SchemaFunctionName {
    private final String schemaName;
    private final String functionName;

    @JsonCreator
    public SchemaFunctionName(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="functionName") String functionName) {
        this.schemaName = schemaName.toLowerCase(Locale.ROOT);
        if (schemaName.isEmpty()) {
            throw new IllegalArgumentException("schemaName is empty");
        }
        this.functionName = functionName.toLowerCase(Locale.ROOT);
        if (functionName.isEmpty()) {
            throw new IllegalArgumentException("functionName is empty");
        }
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getFunctionName() {
        return this.functionName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.functionName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaFunctionName other = (SchemaFunctionName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.functionName, other.functionName);
    }

    public String toString() {
        return this.schemaName + "." + this.functionName;
    }
}

