/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.transaction;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public enum IsolationLevel {
    SERIALIZABLE,
    REPEATABLE_READ,
    READ_COMMITTED,
    READ_UNCOMMITTED;


    public boolean meetsRequirementOf(IsolationLevel requirement) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> {
                if (requirement == READ_UNCOMMITTED) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED || requirement == REPEATABLE_READ) {
                    yield true;
                }
                yield false;
            }
            case 0 -> true;
        };
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }

    public static void checkConnectorSupports(IsolationLevel supportedLevel, IsolationLevel requestedLevel) {
        if (!supportedLevel.meetsRequirementOf(requestedLevel)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ISOLATION_LEVEL, String.format("Connector supported isolation level %s does not meet requested isolation level %s", new Object[]{supportedLevel, requestedLevel}));
        }
    }
}

