/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.microsoft.azure.management.servicebus.ServiceBusSubscription;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.TopicAuthorizationRule;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusNamespaceImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusSubscriptionsImpl;
import com.microsoft.azure.management.servicebus.implementation.TimeSpan;
import com.microsoft.azure.management.servicebus.implementation.TopicAuthorizationRulesImpl;
import com.microsoft.azure.management.servicebus.implementation.TopicInner;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition
class TopicImpl
extends IndependentChildResourceImpl<Topic, ServiceBusNamespaceImpl, TopicInner, TopicImpl, ServiceBusManager>
implements Topic,
Topic.Definition,
Topic.Update {
    private List<Creatable<ServiceBusSubscription>> subscriptionsToCreate;
    private List<Creatable<TopicAuthorizationRule>> rulesToCreate;
    private List<String> subscriptionsToDelete;
    private List<String> rulesToDelete;

    TopicImpl(String resourceGroupName, String namespaceName, String name, Region region, TopicInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
        if (inner.location() == null) {
            inner.withLocation(region.toString());
        }
    }

    @Override
    public DateTime createdAt() {
        return ((TopicInner)((Object)this.inner())).createdAt();
    }

    @Override
    public DateTime accessedAt() {
        return ((TopicInner)((Object)this.inner())).accessedAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((TopicInner)((Object)this.inner())).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).maxSizeInMegabytes());
    }

    @Override
    public long currentSizeInBytes() {
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((TopicInner)((Object)this.inner())).enableBatchedOperations());
    }

    @Override
    public boolean isExpressEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((TopicInner)((Object)this.inner())).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((TopicInner)((Object)this.inner())).enablePartitioning());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((TopicInner)((Object)this.inner())).requiresDuplicateDetection());
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((TopicInner)((Object)this.inner())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((TopicInner)((Object)this.inner())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Period defaultMessageTtlDuration() {
        if (((TopicInner)((Object)this.inner())).defaultMessageTimeToLive() == null) {
            return null;
        }
        TimeSpan timeSpan = TimeSpan.parse(((TopicInner)((Object)this.inner())).defaultMessageTimeToLive());
        return new Period().withDays(timeSpan.days()).withHours(timeSpan.hours()).withMinutes(timeSpan.minutes()).withSeconds(timeSpan.seconds()).withMillis(timeSpan.milliseconds());
    }

    @Override
    public Period duplicateMessageDetectionHistoryDuration() {
        if (((TopicInner)((Object)this.inner())).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        TimeSpan timeSpan = TimeSpan.parse(((TopicInner)((Object)this.inner())).duplicateDetectionHistoryTimeWindow());
        return new Period().withDays(timeSpan.days()).withHours(timeSpan.hours()).withMinutes(timeSpan.minutes()).withSeconds(timeSpan.seconds()).withMillis(timeSpan.milliseconds());
    }

    @Override
    public long activeMessageCount() {
        if (((TopicInner)((Object)this.inner())).countDetails() == null || ((TopicInner)((Object)this.inner())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((TopicInner)((Object)this.inner())).countDetails() == null || ((TopicInner)((Object)this.inner())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((TopicInner)((Object)this.inner())).countDetails() == null || ((TopicInner)((Object)this.inner())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((TopicInner)((Object)this.inner())).countDetails() == null || ((TopicInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((TopicInner)((Object)this.inner())).countDetails() == null || ((TopicInner)((Object)this.inner())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((TopicInner)((Object)this.inner())).countDetails().transferMessageCount());
    }

    @Override
    public int subscriptionCount() {
        if (((TopicInner)((Object)this.inner())).subscriptionCount() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((TopicInner)((Object)this.inner())).subscriptionCount());
    }

    @Override
    public EntityStatus status() {
        return ((TopicInner)((Object)this.inner())).status();
    }

    @Override
    public ServiceBusSubscriptionsImpl subscriptions() {
        return new ServiceBusSubscriptionsImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public TopicAuthorizationRulesImpl authorizationRules() {
        return new TopicAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public TopicImpl withSizeInMB(long sizeInMB) {
        ((TopicInner)((Object)this.inner())).withMaxSizeInMegabytes(sizeInMB);
        return this;
    }

    @Override
    public TopicImpl withPartitioning() {
        ((TopicInner)((Object)this.inner())).withEnablePartitioning(true);
        return this;
    }

    @Override
    public TopicImpl withoutPartitioning() {
        ((TopicInner)((Object)this.inner())).withEnablePartitioning(false);
        return this;
    }

    @Override
    public TopicImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((TopicInner)((Object)this.inner())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public TopicImpl withDefaultMessageTTL(Period ttl) {
        ((TopicInner)((Object)this.inner())).withDefaultMessageTimeToLive(TimeSpan.fromPeriod(ttl).toString());
        return this;
    }

    @Override
    public TopicImpl withExpressMessage() {
        ((TopicInner)((Object)this.inner())).withEnableExpress(true);
        return this;
    }

    @Override
    public TopicImpl withoutExpressMessage() {
        ((TopicInner)((Object)this.inner())).withEnableExpress(false);
        return this;
    }

    @Override
    public TopicImpl withMessageBatching() {
        ((TopicInner)((Object)this.inner())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public TopicImpl withoutMessageBatching() {
        ((TopicInner)((Object)this.inner())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetection(Period duplicateDetectionHistoryDuration) {
        ((TopicInner)((Object)this.inner())).withRequiresDuplicateDetection(true);
        ((TopicInner)((Object)this.inner())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromPeriod(duplicateDetectionHistoryDuration).toString());
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetectionHistoryDuration(Period duration) {
        ((TopicInner)((Object)this.inner())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromPeriod(duration).toString());
        return this;
    }

    @Override
    public TopicImpl withoutDuplicateMessageDetection() {
        ((TopicInner)((Object)this.inner())).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public TopicImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withSendingEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withListeningEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withManagementEnabled());
        return this;
    }

    @Override
    public TopicImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    @Override
    public TopicImpl withNewSubscription(String name) {
        this.subscriptionsToCreate.add(this.subscriptions().define(name));
        return this;
    }

    @Override
    public TopicImpl withoutSubscription(String name) {
        this.subscriptionsToDelete.add(name);
        return this;
    }

    protected Observable<TopicInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    protected Observable<Topic> createChildResourceAsync() {
        Completable createTopicCompletable = ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), (TopicInner)((Object)this.inner())).map((Func1)new Func1<TopicInner, TopicInner>(){

            public TopicInner call(TopicInner inner) {
                TopicImpl.this.setInner((Object)inner);
                return inner;
            }
        }).toCompletable();
        Completable childrenOperationsCompletable = this.submitChildrenOperationsAsync();
        TopicImpl self = this;
        return Completable.concat((Completable[])new Completable[]{createTopicCompletable, childrenOperationsCompletable}).doOnTerminate(new Action0(){

            public void call() {
                TopicImpl.this.initChildrenOperationsCache();
            }
        }).andThen(Observable.just((Object)self));
    }

    private void initChildrenOperationsCache() {
        this.subscriptionsToCreate = new ArrayList<Creatable<ServiceBusSubscription>>();
        this.rulesToCreate = new ArrayList<Creatable<TopicAuthorizationRule>>();
        this.subscriptionsToDelete = new ArrayList<String>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Completable submitChildrenOperationsAsync() {
        Observable subscriptionsCreateStream = Observable.empty();
        if (this.subscriptionsToCreate.size() > 0) {
            subscriptionsCreateStream = this.subscriptions().createAsync(this.subscriptionsToCreate);
        }
        Observable rulesCreateStream = Observable.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate);
        }
        Observable<String> subscriptionsDeleteStream = Observable.empty();
        if (this.subscriptionsToDelete.size() > 0) {
            subscriptionsDeleteStream = this.subscriptions().deleteByNameAsync(this.subscriptionsToDelete);
        }
        Observable<String> rulesDeleteStream = Observable.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Completable.mergeDelayError((Completable[])new Completable[]{subscriptionsCreateStream.toCompletable(), rulesCreateStream.toCompletable(), subscriptionsDeleteStream.toCompletable(), rulesDeleteStream.toCompletable()});
    }
}

