/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.servicebus.AccessRights;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.RegenerateKeysParameters;
import com.microsoft.azure.management.servicebus.implementation.PageImpl;
import com.microsoft.azure.management.servicebus.implementation.ResourceListKeysInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import com.microsoft.azure.management.servicebus.implementation.TopicInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TopicsInner {
    private TopicsService service;
    private ServiceBusManagementClientImpl client;

    public TopicsInner(Retrofit retrofit, ServiceBusManagementClientImpl client) {
        this.service = (TopicsService)retrofit.create(TopicsService.class);
        this.client = client;
    }

    public PagedList<TopicInner> listByNamespace(String resourceGroupName, String namespaceName) {
        ServiceResponse response = (ServiceResponse)this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<TopicInner>((Page)response.body()){

            public Page<TopicInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopicsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TopicInner>> listByNamespaceAsync(String resourceGroupName, String namespaceName, ListOperationCallback<TopicInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(String nextPageLink) {
                return TopicsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TopicInner>> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return this.listByNamespaceWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Page<TopicInner>>, Page<TopicInner>>(){

            public Page<TopicInner> call(ServiceResponse<Page<TopicInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TopicInner>>> listByNamespaceWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        return this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName).concatMap((Func1)new Func1<ServiceResponse<Page<TopicInner>>, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(ServiceResponse<Page<TopicInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopicsInner.this.listByNamespaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TopicInner>>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByNamespace(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopicsInner.this.listByNamespaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TopicInner>> listByNamespaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TopicInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TopicInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, TopicInner parameters) {
        return (TopicInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<TopicInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, TopicInner parameters, ServiceCallback<TopicInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, parameters), serviceCallback);
    }

    public Observable<TopicInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, TopicInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, parameters).map((Func1)new Func1<ServiceResponse<TopicInner>, TopicInner>(){

            public TopicInner call(ServiceResponse<TopicInner> response) {
                return (TopicInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TopicInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, TopicInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TopicInner>>>(){

            public Observable<ServiceResponse<TopicInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TopicInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TopicInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName, String topicName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TopicInner get(String resourceGroupName, String namespaceName, String topicName) {
        return (TopicInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).toBlocking().single()).body());
    }

    public ServiceFuture<TopicInner> getAsync(String resourceGroupName, String namespaceName, String topicName, ServiceCallback<TopicInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName), serviceCallback);
    }

    public Observable<TopicInner> getAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).map((Func1)new Func1<ServiceResponse<TopicInner>, TopicInner>(){

            public TopicInner call(ServiceResponse<TopicInner> response) {
                return (TopicInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TopicInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TopicInner>>>(){

            public Observable<ServiceResponse<TopicInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TopicInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TopicInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String topicName) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>((Page)response.body()){

            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopicsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName, ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                return TopicsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName, topicName).map((Func1)new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>(){

            public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, topicName).concatMap((Func1)new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopicsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAuthorizationRules(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopicsInner.this.listAuthorizationRulesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SharedAccessAuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights) {
        return (SharedAccessAuthorizationRuleInner)((Object)((ServiceResponse)this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights).toBlocking().single()).body());
    }

    public ServiceFuture<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights, ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights), serviceCallback);
    }

    public Observable<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights) {
        return this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, rights).map((Func1)new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>(){

            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return (SharedAccessAuthorizationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, List<AccessRights> rights) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rights == null) {
            throw new IllegalArgumentException("Parameter rights is required and cannot be null.");
        }
        Validator.validate(rights);
        SharedAccessAuthorizationRuleInner parameters = new SharedAccessAuthorizationRuleInner();
        parameters.withRights(rights);
        return this.service.createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.createOrUpdateAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SharedAccessAuthorizationRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SharedAccessAuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (SharedAccessAuthorizationRuleInner)((Object)((ServiceResponse)this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName), serviceCallback);
    }

    public Observable<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>(){

            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return (SharedAccessAuthorizationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAuthorizationRule(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.getAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SharedAccessAuthorizationRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        ((ServiceResponse)this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName), serviceCallback);
    }

    public Observable<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAuthorizationRule(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.deleteAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceListKeysInner listKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (ResourceListKeysInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName), serviceCallback);
    }

    public Observable<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>(){

            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return (ResourceListKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceListKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>(){

            public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceListKeysInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceListKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return (ResourceListKeysInner)((ServiceResponse)this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName), serviceCallback);
    }

    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        return this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>(){

            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return (ResourceListKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object policykey = null;
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(null);
        return this.service.regenerateKeys(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>(){

            public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.regenerateKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey) {
        return (ResourceListKeysInner)((ServiceResponse)this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey, ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey), serviceCallback);
    }

    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey) {
        return this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, authorizationRuleName, policykey).map((Func1)new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>(){

            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return (ResourceListKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String authorizationRuleName, Policykey policykey) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(policykey);
        return this.service.regenerateKeys(resourceGroupName, namespaceName, topicName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>(){

            public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopicsInner.this.regenerateKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceListKeysInner> regenerateKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceListKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<TopicInner> listByNamespaceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TopicInner>((Page)response.body()){

            public Page<TopicInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopicsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TopicInner>> listByNamespaceNextAsync(String nextPageLink, ServiceFuture<List<TopicInner>> serviceFuture, ListOperationCallback<TopicInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByNamespaceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(String nextPageLink) {
                return TopicsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TopicInner>> listByNamespaceNextAsync(String nextPageLink) {
        return this.listByNamespaceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TopicInner>>, Page<TopicInner>>(){

            public Page<TopicInner> call(ServiceResponse<Page<TopicInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TopicInner>>> listByNamespaceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByNamespaceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TopicInner>>, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(ServiceResponse<Page<TopicInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopicsInner.this.listByNamespaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TopicInner>>> listByNamespaceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByNamespaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TopicInner>>>>(){

            public Observable<ServiceResponse<Page<TopicInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopicsInner.this.listByNamespaceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TopicInner>> listByNamespaceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TopicInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRulesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>((Page)response.body()){

            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopicsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink, ServiceFuture<List<SharedAccessAuthorizationRuleInner>> serviceFuture, ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                return TopicsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>(){

            public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopicsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopicsInner.this.listAuthorizationRulesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TopicsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics listByNamespace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics")
        public Observable<Response<ResponseBody>> listByNamespace(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionId") String var4, @Body TopicInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics listAuthorizationRules"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules")
        public Observable<Response<ResponseBody>> listAuthorizationRules(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics createOrUpdateAuthorizationRule"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdateAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body SharedAccessAuthorizationRuleInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics getAuthorizationRule"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> getAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics deleteAuthorizationRule"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/ListKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics regenerateKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/regenerateKeys")
        public Observable<Response<ResponseBody>> regenerateKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="topicName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body RegenerateKeysParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics listByNamespaceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByNamespaceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Topics listAuthorizationRulesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

