/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

public class Suggestion {
    static void suggestNegativeViolations(Ctx ctx, Function<Set<String>, List<String>> shardSorter) {
        if (ctx.violation.coll == null) {
            return;
        }
        HashSet shardSet = new HashSet();
        if (!ctx.needMore()) {
            return;
        }
        for (Row node : ctx.session.matrix) {
            node.forEachShard(ctx.violation.coll, (s, ri) -> {
                if ("#ANY".equals(ctx.violation.shard) || s.equals(ctx.violation.shard)) {
                    shardSet.add(s);
                }
            });
        }
        List<String> shards = shardSorter.apply(shardSet);
        block1: for (int i = 0; i < 5 && ctx.needMore(); ++i) {
            int totalSuggestions = 0;
            for (String shard : shards) {
                Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(ctx.violation.coll, shard)).forceOperation(true);
                SolrRequest op = ctx.addSuggestion(suggester);
                if (op == null) continue;
                ++totalSuggestions;
                boolean violationStillExists = false;
                for (Violation violation : suggester.session.getViolations()) {
                    if (violation.getClause().original != ctx.violation.getClause().original) continue;
                    violationStillExists = true;
                    break;
                }
                if (violationStillExists) continue;
                break block1;
            }
            if (totalSuggestions == 0) break;
        }
    }

    static void suggestPositiveViolations(Ctx ctx) {
        if (ctx.violation == null) {
            return;
        }
        Double currentDelta = ctx.violation.replicaCountDelta;
        for (Violation.ReplicaInfoAndErr e : ctx.violation.getViolatingReplicas()) {
            if (!ctx.needMore() || currentDelta <= 0.0) break;
            Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).forceOperation(true).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(e.replicaInfo.getCollection(), e.replicaInfo.getShard())).hint(Suggester.Hint.SRC_NODE, e.replicaInfo.getNode());
            if (ctx.addSuggestion(suggester) == null) continue;
            Double d = currentDelta;
            Double d2 = currentDelta = Double.valueOf(currentDelta - 1.0);
        }
    }

    static class Ctx {
        long endTime = -1L;
        int max = Integer.MAX_VALUE;
        public Policy.Session session;
        public Violation violation;
        List<Suggester.SuggestionInfo> suggestions = new ArrayList<Suggester.SuggestionInfo>();

        Ctx() {
        }

        SolrRequest addSuggestion(Suggester suggester) {
            return this.addSuggestion(suggester, Type.violation);
        }

        SolrRequest addSuggestion(Suggester suggester, Type type) {
            SolrRequest op = suggester.getSuggestion();
            if (op != null) {
                this.session = suggester.getSession();
                this.suggestions.add(new Suggester.SuggestionInfo(this.violation, ((V2RequestSupport)((Object)op.setUseV2(true))).getV2Request(), type));
            }
            return op;
        }

        public Ctx setViolation(Violation violation) {
            this.violation = violation;
            return this;
        }

        public List<Suggester.SuggestionInfo> getSuggestions() {
            return this.suggestions;
        }

        public boolean hasTimedOut() {
            return this.session.cloudManager.getTimeSource().getTimeNs() >= this.endTime;
        }

        public boolean needMore() {
            return this.suggestions.size() < this.max && !this.hasTimedOut();
        }
    }

    public static enum Type {
        violation,
        repair,
        improvement,
        unresolved_violation;

    }
}

