/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerService;
import com.microsoft.azure.management.containerservice.ContainerServices;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceInner;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.ContainerServicesInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ContainerServicesImpl
extends GroupableResourcesImpl<ContainerService, ContainerServiceImpl, ContainerServiceInner, ContainerServicesInner, ContainerServiceManager>
implements ContainerServices {
    ContainerServicesImpl(ContainerServiceManager containerServiceManager) {
        super((Object)((ContainerServiceManagementClientImpl)((Object)containerServiceManager.inner())).containerServices(), (ManagerBase)containerServiceManager);
    }

    public PagedList<ContainerService> list() {
        final ContainerServicesImpl self = this;
        return new GroupPagedList<ContainerService>(((ContainerServiceManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<ContainerService> listNextGroup(String resourceGroupName) {
                return ContainerServicesImpl.this.wrapList(((ContainerServicesInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<ContainerService> listAsync() {
        return ((ContainerServiceManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<ContainerService>>(){

            public Observable<ContainerService> call(ResourceGroup resourceGroup) {
                return ContainerServicesImpl.this.wrapPageAsync(((ContainerServicesInner)ContainerServicesImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public Observable<ContainerService> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((ContainerServicesInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedList<ContainerService> listByResourceGroup(String groupName) {
        return this.wrapList(((ContainerServicesInner)this.inner()).listByResourceGroup(groupName));
    }

    protected Observable<ContainerServiceInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ContainerServicesInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public ContainerServiceImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Completable deleteInnerAsync(String groupName, String name) {
        return ((ContainerServicesInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    protected ContainerServiceImpl wrapModel(String name) {
        return new ContainerServiceImpl(name, new ContainerServiceInner(), (ContainerServiceManager)this.manager());
    }

    protected ContainerServiceImpl wrapModel(ContainerServiceInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new ContainerServiceImpl(containerServiceInner.name(), containerServiceInner, (ContainerServiceManager)this.manager());
    }
}

