/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.messagesecurity.MessageSecurityHelper;
import java.io.IOException;
import java.util.Objects;

class JWSHeader {
    private String alg;
    private String kid;
    private String at;
    private long ts;
    private String p;
    private String typ;

    JWSHeader() {
    }

    JWSHeader(String alg, String kid, String at, long ts, String typ, String p) {
        this.alg = alg;
        this.kid = kid;
        this.at = at;
        this.ts = ts;
        this.p = p;
        this.typ = typ;
    }

    public boolean equals(JWSHeader other) {
        return this.alg.equals(other.alg) && this.kid.equals(other.kid) && this.at.equals(other.at) && this.ts == other.ts && this.p.equals(other.p) && this.typ.equals(other.typ);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JWSHeader)) {
            return false;
        }
        return object == this || this.equals((JWSHeader)object);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.kid, this.at, this.ts, this.p, this.typ);
    }

    public String serialize() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static JWSHeader deserialize(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JWSHeader)mapper.readValue(json, JWSHeader.class);
    }

    public static JWSHeader fromBase64String(String base64) throws IOException {
        String json = MessageSecurityHelper.base64UrltoString(base64);
        ObjectMapper mapper = new ObjectMapper();
        return (JWSHeader)mapper.readValue(json, JWSHeader.class);
    }

    @JsonProperty(value="alg")
    public String alg() {
        return this.alg;
    }

    @JsonProperty(value="kid")
    public String kid() {
        return this.kid;
    }

    @JsonProperty(value="at")
    public String at() {
        return this.at;
    }

    @JsonProperty(value="ts")
    public long ts() {
        return this.ts;
    }

    @JsonProperty(value="typ")
    public String typ() {
        return this.typ;
    }

    @JsonProperty(value="p")
    public String p() {
        return this.p;
    }
}

