/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

class MessageSecurityHelper {
    private static final Charset MESSAGE_ENCODING = StandardCharsets.UTF_8;

    MessageSecurityHelper() {
    }

    public static byte[] base64UrltoByteArray(String base64url) {
        return Base64.decodeBase64((String)base64url.replace('-', '+').replace('_', '/'));
    }

    public static String base64UrltoString(String base64url) {
        return new String(MessageSecurityHelper.base64UrltoByteArray(base64url), MESSAGE_ENCODING);
    }

    public static String bytesToBase64Url(byte[] bytes) {
        String result = new String(Base64.encodeBase64((byte[])bytes), MESSAGE_ENCODING).replace("=", "").replace("\\", "").replace('+', '-').replace('/', '_');
        return result;
    }

    public static String stringToBase64Url(String str) {
        return MessageSecurityHelper.bytesToBase64Url(str.getBytes(MESSAGE_ENCODING));
    }

    public static JsonWebKey jsonWebKeyFromString(String jwkString) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JsonWebKey)mapper.readValue(jwkString, JsonWebKey.class);
    }

    public static JsonWebKey generateJsonWebKey() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            KeyPair clientRsaKeyPair = generator.generateKeyPair();
            JsonWebKey result = JsonWebKey.fromRSA((KeyPair)clientRsaKeyPair);
            result.withKid(UUID.randomUUID().toString());
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonWebKey getJwkWithPublicKeyOnly(JsonWebKey jwk) {
        KeyPair publicOnly = jwk.toRSA(false);
        JsonWebKey jsonkeyPublic = JsonWebKey.fromRSA((KeyPair)publicOnly);
        jsonkeyPublic.withKid(jwk.kid());
        jsonkeyPublic.withKeyOps(Arrays.asList(JsonWebKeyOperation.ENCRYPT, JsonWebKeyOperation.WRAP_KEY, JsonWebKeyOperation.VERIFY));
        return jsonkeyPublic;
    }
}

