/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filter.util;

public class BitsArray
implements Cloneable {
    private byte[] bytes;
    private int bitLength;

    public static BitsArray create(int bitLength) {
        return new BitsArray(bitLength);
    }

    public static BitsArray create(byte[] bytes, int bitLength) {
        return new BitsArray(bytes, bitLength);
    }

    public static BitsArray create(byte[] bytes) {
        return new BitsArray(bytes);
    }

    private BitsArray(int bitLength) {
        this.bitLength = bitLength;
        int temp = bitLength / 8;
        if (bitLength % 8 > 0) {
            ++temp;
        }
        this.bytes = new byte[temp];
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
    }

    private BitsArray(byte[] bytes, int bitLength) {
        if (bytes == null || bytes.length < 1) {
            throw new IllegalArgumentException("Bytes is empty!");
        }
        if (bitLength < 1) {
            throw new IllegalArgumentException("Bit is less than 1.");
        }
        if (bitLength < bytes.length * 8) {
            throw new IllegalArgumentException("BitLength is less than bytes.length() * 8");
        }
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, this.bytes.length);
        this.bitLength = bitLength;
    }

    private BitsArray(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            throw new IllegalArgumentException("Bytes is empty!");
        }
        this.bitLength = bytes.length * 8;
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, this.bytes.length);
    }

    public int bitLength() {
        return this.bitLength;
    }

    public int byteLength() {
        return this.bytes.length;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public void xor(BitsArray other) {
        this.checkInitialized(this);
        this.checkInitialized(other);
        int minByteLength = Math.min(this.byteLength(), other.byteLength());
        for (int i = 0; i < minByteLength; ++i) {
            this.bytes[i] = (byte)(this.bytes[i] ^ other.getByte(i));
        }
    }

    public void xor(int bitPos, boolean set) {
        this.checkBitPosition(bitPos, this);
        boolean value = this.getBit(bitPos);
        if (value ^ set) {
            this.setBit(bitPos, true);
        } else {
            this.setBit(bitPos, false);
        }
    }

    public void or(BitsArray other) {
        this.checkInitialized(this);
        this.checkInitialized(other);
        int minByteLength = Math.min(this.byteLength(), other.byteLength());
        for (int i = 0; i < minByteLength; ++i) {
            this.bytes[i] = (byte)(this.bytes[i] | other.getByte(i));
        }
    }

    public void or(int bitPos, boolean set) {
        this.checkBitPosition(bitPos, this);
        if (set) {
            this.setBit(bitPos, true);
        }
    }

    public void and(BitsArray other) {
        this.checkInitialized(this);
        this.checkInitialized(other);
        int minByteLength = Math.min(this.byteLength(), other.byteLength());
        for (int i = 0; i < minByteLength; ++i) {
            this.bytes[i] = (byte)(this.bytes[i] & other.getByte(i));
        }
    }

    public void and(int bitPos, boolean set) {
        this.checkBitPosition(bitPos, this);
        if (!set) {
            this.setBit(bitPos, false);
        }
    }

    public void not(int bitPos) {
        this.checkBitPosition(bitPos, this);
        this.setBit(bitPos, !this.getBit(bitPos));
    }

    public void setBit(int bitPos, boolean set) {
        this.checkBitPosition(bitPos, this);
        int sub = this.subscript(bitPos);
        int pos = this.position(bitPos);
        this.bytes[sub] = set ? (byte)(this.bytes[sub] | pos) : (byte)(this.bytes[sub] & ~pos);
    }

    public void setByte(int bytePos, byte set) {
        this.checkBytePosition(bytePos, this);
        this.bytes[bytePos] = set;
    }

    public boolean getBit(int bitPos) {
        this.checkBitPosition(bitPos, this);
        return (this.bytes[this.subscript(bitPos)] & this.position(bitPos)) != 0;
    }

    public byte getByte(int bytePos) {
        this.checkBytePosition(bytePos, this);
        return this.bytes[bytePos];
    }

    protected int subscript(int bitPos) {
        return bitPos / 8;
    }

    protected int position(int bitPos) {
        return 1 << bitPos % 8;
    }

    protected void checkBytePosition(int bytePos, BitsArray bitsArray) {
        this.checkInitialized(bitsArray);
        if (bytePos > bitsArray.byteLength()) {
            throw new IllegalArgumentException("BytePos is greater than " + this.bytes.length);
        }
        if (bytePos < 0) {
            throw new IllegalArgumentException("BytePos is less than 0");
        }
    }

    protected void checkBitPosition(int bitPos, BitsArray bitsArray) {
        this.checkInitialized(bitsArray);
        if (bitPos > bitsArray.bitLength()) {
            throw new IllegalArgumentException("BitPos is greater than " + this.bitLength);
        }
        if (bitPos < 0) {
            throw new IllegalArgumentException("BitPos is less than 0");
        }
    }

    protected void checkInitialized(BitsArray bitsArray) {
        if (bitsArray.bytes() == null) {
            throw new RuntimeException("Not initialized!");
        }
    }

    public BitsArray clone() {
        byte[] clone = new byte[this.byteLength()];
        System.arraycopy(this.bytes, 0, clone, 0, this.byteLength());
        return BitsArray.create(clone, this.bitLength());
    }

    public String toString() {
        if (this.bytes == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(this.bytes.length * 8);
        for (int i = this.bytes.length - 1; i >= 0; --i) {
            int j = 7;
            if (i == this.bytes.length - 1 && this.bitLength % 8 > 0) {
                j = this.bitLength % 8;
            }
            while (j >= 0) {
                byte mask = (byte)(1 << j);
                if ((this.bytes[i] & mask) == mask) {
                    stringBuilder.append("1");
                } else {
                    stringBuilder.append("0");
                }
                --j;
            }
            if (i % 8 != 0) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

