/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FileConfigurator {
    static final String pad = "   ";

    public static void load(ConfigurationBuffer buffer, Reader r, String path, String rootElement) throws ConfigurationException {
        FileConfigurator.load(buffer, r, path, null, rootElement);
    }

    public static void load(ConfigurationBuffer buffer, Reader r, String path, String context, String rootElement) throws ConfigurationException {
        ThreadLocalToolkit.log(new LoadingConfiguration(path));
        Handler h = new Handler(buffer, path, context, rootElement, false);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(r);
            parser.parse(source, (DefaultHandler)h);
        }
        catch (SAXConfigurationException e) {
            throw e.innerException;
        }
        catch (SAXParseException e) {
            throw new ConfigurationException.OtherThrowable(e, null, path, e.getLineNumber());
        }
        catch (Exception e) {
            throw new ConfigurationException.OtherThrowable(e, null, path, -1);
        }
    }

    public static void load(ConfigurationBuffer buffer, InputStream r, String path, String rootElement) throws ConfigurationException {
        FileConfigurator.load(buffer, r, path, null, rootElement, false);
    }

    public static void load(ConfigurationBuffer buffer, InputStream r, String path, String context, String rootElement, boolean ignoreUnknownItems) throws ConfigurationException {
        ThreadLocalToolkit.log(new LoadingConfiguration(path));
        Handler h = new Handler(buffer, path, context, rootElement, ignoreUnknownItems);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(r);
            parser.parse(source, (DefaultHandler)h);
        }
        catch (SAXConfigurationException e) {
            throw e.innerException;
        }
        catch (SAXParseException e) {
            throw new ConfigurationException.OtherThrowable(e, null, path, e.getLineNumber());
        }
        catch (Exception e) {
            throw new ConfigurationException.OtherThrowable(e, null, path, -1);
        }
    }

    public static void load(ConfigurationBuffer buffer, String path, String rootElement) throws ConfigurationException {
        FileConfigurator.load(buffer, path, null, -1, rootElement);
    }

    public static void load(ConfigurationBuffer buffer, String path, String contextPath, int line, String rootElement) throws ConfigurationException {
        try {
            File f = new File(FileConfigurator.getFilePath(path, contextPath));
            BufferedInputStream r = new BufferedInputStream(new FileInputStream(f));
            FileConfigurator.load(buffer, r, f.getAbsolutePath(), f.getParent(), rootElement, false);
            try {
                ((InputStream)r).close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException.ConfigurationIOError(path, null, contextPath, line);
        }
    }

    private static String getFilePath(String path, String contextPath) {
        File f = new File(path);
        if (!(contextPath == null || f.exists() && f.isAbsolute())) {
            f = new File(contextPath + File.separator + path);
        }
        return f.getAbsolutePath();
    }

    private static String name(String var, String base) {
        return base == null ? var : base + "." + var;
    }

    private static String classToArgName(Class c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    private static String formatBuffer1(ConfigurationBuffer cfgbuf, FormatNode node, String indent, String prefix) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(indent + "<" + node.shortname + ">\n");
        if (node.children != null) {
            for (Map.Entry<String, FormatNode> e : node.children.entrySet()) {
                boolean newline;
                FormatNode child = e.getValue();
                if (child.children != null) {
                    buf.append(FileConfigurator.formatBuffer1(cfgbuf, child, indent + pad, prefix));
                    continue;
                }
                String description = prefix + "." + child.fullname;
                if (description != null) {
                    buf.append(indent + "   <!-- " + child.fullname + ": " + description + "-->\n");
                }
                if (child.values == null || !child.info.isDisplayed()) {
                    newline = false;
                    buf.append(indent + "   <!-- " + child.fullname + " usage:\n");
                    buf.append(indent + "   <" + child.shortname + ">");
                    int i = 0;
                    while (true) {
                        if (child.info.getArgCount() == 1) {
                            buf.append(child.info.getArgName(i));
                            break;
                        }
                        buf.append("\n" + indent + "      <" + child.info.getArgName(i) + ">" + FileConfigurator.classToArgName(child.info.getArgType(i)) + "</" + child.info.getArgName(i) + ">");
                        newline = true;
                        if (child.info.getArgCount() == -1) {
                            if (i > 0) {
                                boolean found = false;
                                String argName = child.info.getArgName(i + 1);
                                for (int j = i; j >= 0; --j) {
                                    if (!child.info.getArgName(j).equals(argName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    break;
                                }
                            }
                        } else if (i >= child.info.getArgCount()) break;
                        ++i;
                    }
                    if (newline) {
                        buf.append("\n" + indent + pad);
                    }
                    buf.append("</" + child.shortname + ">\n");
                    buf.append(indent + "   -->\n");
                    continue;
                }
                newline = false;
                for (ConfigurationValue cv : child.values) {
                    buf.append(indent + "   <" + child.shortname + ">");
                    int argCount = child.info.getArgCount();
                    int argc = 0;
                    for (String arg : cv.getArgs()) {
                        if (argCount == 1) {
                            buf.append(arg);
                            break;
                        }
                        String argname = child.info.getArgName(argc++);
                        newline = true;
                        buf.append("\n" + indent + "      <" + argname + ">" + arg + "</" + argname + ">");
                    }
                    if (newline) {
                        buf.append("\n" + indent + pad);
                    }
                    buf.append("</" + child.shortname + ">\n");
                }
            }
        }
        buf.append(indent + "</" + node.shortname + ">\n");
        return buf.toString();
    }

    private static void addNode(ConfigurationBuffer cfgbuf, String var, FormatNode root) {
        Object name = null;
        StringTokenizer t = new StringTokenizer(var, ".");
        FormatNode current = root;
        while (t.hasMoreTokens()) {
            FormatNode node;
            String token = t.nextToken();
            name = name == null ? token : (String)name + "." + token;
            if (current.children == null) {
                current.children = new TreeMap();
            }
            if (cfgbuf.isChildConfig((String)name)) {
                if (!current.children.containsKey(token)) {
                    node = new FormatNode();
                    node.fullname = name;
                    node.shortname = token;
                    node.children = new TreeMap();
                    current.children.put(token, node);
                    current = node;
                    continue;
                }
                current = current.children.get(token);
                continue;
            }
            if (!cfgbuf.isValidVar((String)name)) continue;
            node = new FormatNode();
            node.fullname = name;
            node.shortname = token;
            node.info = cfgbuf.getInfo((String)name);
            node.values = cfgbuf.getVar((String)name);
            current.children.put(token, node);
        }
    }

    public static String formatBuffer(ConfigurationBuffer cfgbuf, String rootElement, String prefix) {
        FormatNode root = new FormatNode();
        root.shortname = rootElement;
        Iterator<String> it = cfgbuf.getVarIterator();
        while (it.hasNext()) {
            String var = it.next();
            ConfigurationInfo info = cfgbuf.getInfo(var);
            if (info != null && (info.isHidden() || !info.isDisplayed())) continue;
            FileConfigurator.addNode(cfgbuf, var, root);
        }
        return FileConfigurator.formatBuffer1(cfgbuf, root, "", prefix);
    }

    public static String formatBuffer(ConfigurationBuffer cfgbuf, String rootElement) {
        return FileConfigurator.formatBuffer(cfgbuf, rootElement, null);
    }

    public static class LoadingConfiguration
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 7288323144791549482L;
        public String file;

        public LoadingConfiguration(String file) {
            this.file = file;
        }
    }

    private static class Handler
    extends DefaultHandler {
        private Stack<ParseContext> contextStack = new Stack();
        private final ConfigurationBuffer cfgbuf;
        private final String source;
        private final String contextPath;
        private final String rootElement;
        private final boolean ignoreUnknownItems;
        private Locator locator;
        StringBuilder text = new StringBuilder();

        public Handler(ConfigurationBuffer buffer, String source, String contextPath, String rootElement, boolean ignoreUnknownItems) {
            this.cfgbuf = buffer;
            this.source = source;
            this.contextPath = contextPath;
            this.rootElement = rootElement;
            this.ignoreUnknownItems = ignoreUnknownItems;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String element = qName;
            if (this.contextStack.size() == 0) {
                if (!element.equals(this.rootElement)) {
                    throw new SAXConfigurationException(new ConfigurationException.IncorrectElement(this.rootElement, qName, this.source, this.locator.getLineNumber()), this.locator);
                }
                ParseContext ctx = new ParseContext();
                this.contextStack.push(ctx);
                return;
            }
            ParseContext ctx = this.contextStack.peek();
            if (ctx.ignore) {
                return;
            }
            if (this.text.length() > 0) {
                throw new SAXConfigurationException(new ConfigurationException.UnexpectedCDATA(this.source, this.locator.getLineNumber()), this.locator);
            }
            String fullname = FileConfigurator.name(element, ctx.base);
            if (ctx.item != null) {
                throw new SAXConfigurationException(new ConfigurationException.UnexpectedElement(element, this.contextPath, this.locator.getLineNumber()), this.locator);
            }
            if (ctx.var != null) {
                if (ctx.varArgCount == 1) {
                    throw new SAXConfigurationException(new ConfigurationException.UnexpectedElement(element, this.source, this.locator.getLineNumber()), this.locator);
                }
                ctx.item = element;
            } else if (this.cfgbuf.isValidVar(fullname)) {
                ctx.var = fullname;
                ctx.varArgCount = this.cfgbuf.getVarArgCount(ctx.var);
                ctx.append = false;
                String a = attributes.getValue("", "append");
                if (a != null) {
                    try {
                        if (!a.equalsIgnoreCase("true") && !a.equalsIgnoreCase("false")) {
                            throw new SAXConfigurationException(new ConfigurationException.BadAppendValue(ctx.var, this.source, this.locator.getLineNumber()), this.locator);
                        }
                        ctx.append = Boolean.valueOf(a);
                    }
                    catch (Exception e) {
                        throw new SAXConfigurationException(new ConfigurationException.BadAppendValue(ctx.var, this.source, this.locator.getLineNumber()), this.locator);
                    }
                }
            } else if (this.cfgbuf.isChildConfig(fullname)) {
                String src = attributes.getValue("", "file-path");
                if (src != null) {
                    try {
                        Class childClass = this.cfgbuf.getChildConfigClass(fullname);
                        ConfigurationBuffer childBuf = new ConfigurationBuffer(childClass);
                        this.cfgbuf.setVar(element + "-file-path", FileConfigurator.getFilePath(src, this.contextPath), this.contextPath, this.locator.getLineNumber());
                        FileConfigurator.load(childBuf, src, this.contextPath, this.locator.getLineNumber(), element);
                        this.cfgbuf.mergeChild(element, childBuf);
                    }
                    catch (ConfigurationException e) {
                        throw new SAXConfigurationException(e, this.locator);
                    }
                }
                ParseContext newctx = new ParseContext();
                newctx.base = fullname;
                this.contextStack.push(newctx);
            } else {
                if (this.ignoreUnknownItems) {
                    ParseContext newctx = new ParseContext();
                    newctx.item = element;
                    newctx.ignore = true;
                    this.contextStack.push(newctx);
                    return;
                }
                throw new SAXConfigurationException(new ConfigurationException.UnknownVariable(fullname, this.source, this.locator.getLineNumber()), this.locator);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String element = qName;
            ParseContext ctx = this.contextStack.peek();
            if (ctx.ignore) {
                if (ctx.item.equals(element)) {
                    this.contextStack.pop();
                    this.text = new StringBuilder();
                }
                return;
            }
            if (!element.equals(this.rootElement)) {
                if (ctx.item != null) {
                    ParseValue v = new ParseValue();
                    v.name = element;
                    v.value = this.text.toString();
                    v.line = this.locator.getLineNumber();
                    ctx.argList.add(v);
                    this.text = new StringBuilder();
                    ctx.item = null;
                } else if (ctx.var != null) {
                    if (ctx.varArgCount > 1 && ctx.argList.size() == 0) {
                        throw new SAXConfigurationException(new ConfigurationException.IncorrectArgumentCount(ctx.varArgCount, 0, ctx.var, this.source, this.locator.getLineNumber()), this.locator);
                    }
                    if (ctx.varArgCount == 1) {
                        ParseValue v = new ParseValue();
                        v.name = null;
                        v.value = this.text.toString();
                        v.line = this.locator.getLineNumber();
                        ctx.argList.add(v);
                        this.text = new StringBuilder();
                    } else if (this.text.length() > 0) {
                        throw new SAXConfigurationException(new ConfigurationException.UnexpectedCDATA(this.source, this.locator.getLineNumber()), this.locator);
                    }
                    try {
                        this.setVar(ctx.var, ctx.argList, this.locator.getLineNumber(), ctx.append);
                        ctx.var = null;
                        ctx.argList.clear();
                        ctx.item = null;
                        ctx.append = false;
                    }
                    catch (ConfigurationException e) {
                        throw new SAXConfigurationException(e, this.locator);
                    }
                } else {
                    this.contextStack.pop();
                }
            }
        }

        public void setVar(String var, List<ParseValue> argList, int line, boolean append) throws ConfigurationException {
            boolean byName;
            int varArgCount = this.cfgbuf.getVarArgCount(var);
            HashMap<String, String> items = new HashMap<String, String>();
            boolean bl = byName = varArgCount > 1;
            if (byName) {
                for (ParseValue v : argList) {
                    if (items.containsKey(v.name)) {
                        byName = false;
                        break;
                    }
                    items.put(v.name, v.value);
                }
            }
            LinkedList<String> args = new LinkedList<String>();
            if (byName) {
                int argc = 0;
                while (args.size() < items.size()) {
                    String name;
                    String val;
                    if ((val = (String)items.get(name = this.cfgbuf.getVarArgName(var, argc++))) == null) {
                        throw new ConfigurationException.MissingArgument(name, var, this.source, line);
                    }
                    args.add(val);
                }
            } else {
                Iterator<ParseValue> it = argList.iterator();
                int argc = 0;
                while (it.hasNext()) {
                    ParseValue v = it.next();
                    String name = this.cfgbuf.getVarArgName(var, argc++);
                    if (v.name != null && !name.equals(v.name)) {
                        throw new ConfigurationException.UnexpectedArgument(name, v.name, var, this.source, v.line);
                    }
                    args.add(v.value);
                }
            }
            this.cfgbuf.setVar(var, args, this.source, line, this.contextPath, append);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String chars = new String(ch, start, length).trim();
            this.text.append(chars);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    public static class SAXConfigurationException
    extends SAXParseException {
        private static final long serialVersionUID = -3388781933743434302L;
        public ConfigurationException innerException;

        SAXConfigurationException(ConfigurationException e, Locator locator) {
            super(null, locator);
            this.innerException = e;
        }
    }

    private static class FormatNode {
        public String fullname;
        public String shortname;
        public ConfigurationInfo info;
        public List values;
        public TreeMap<String, FormatNode> children;

        private FormatNode() {
        }
    }

    private static class ParseValue {
        public String name;
        public String value;
        public int line;

        private ParseValue() {
        }
    }

    private static class ParseContext {
        public String var = null;
        public String base = null;
        public String item;
        public int varArgCount = -2;
        public boolean append = false;
        public List<ParseValue> argList = new LinkedList<ParseValue>();
        public boolean ignore = false;

        ParseContext() {
        }
    }
}

