/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CommandLineConfigurator;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.ConfigurationPathResolver;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.ICompilerProblemSettings;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.config.FlashBuilderConfigurator;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.graph.GraphMLWriter;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.projects.RoyaleProjectConfigurator;
import org.apache.royale.compiler.internal.targets.LinkageChecker;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.internal.units.ResourceModuleCompilationUnit;
import org.apache.royale.compiler.internal.units.SourceCompilationUnitFactory;
import org.apache.royale.compiler.internal.units.StyleModuleCompilationUnit;
import org.apache.royale.compiler.internal.watcher.WatchThread;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.FileIOProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.problems.UnableToBuildSWFProblem;
import org.apache.royale.compiler.targets.ISWFTarget;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetReport;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swf.Header;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.ISWFWriter;
import org.apache.royale.swf.io.ISWFWriterFactory;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;
import org.apache.royale.utils.FilenameNormalization;

public class MXMLC
implements FlexTool {
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String SWF_EXT = ".swf";
    private static final String DEFAULT_VAR = "file-specs";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    protected Workspace workspace = new Workspace();
    protected RoyaleProject project = new RoyaleProject(this.workspace);
    public Configuration config;
    public ProblemQuery problems = new ProblemQuery();
    public ConfigurationBuffer configBuffer;
    public Class<? extends Configuration> configurationClass = Configuration.class;
    protected Configurator projectConfigurator;
    protected ICompilationUnit mainCU;
    protected SWFTarget target;
    protected long startTime;
    protected ITargetSettings targetSettings;
    private ISWF swfTarget;
    private String swfOutputMessage;

    public static void main(String[] args) {
        int exitCode = MXMLC.staticMainNoExit(args);
        if (exitCode != ExitCode.WATCHING.getCode()) {
            System.exit(exitCode);
        }
    }

    public static int staticMainNoExit(String[] args) {
        MXMLC mxmlc = new MXMLC();
        return mxmlc.mainNoExit(args);
    }

    public static boolean isFatalFailure(int code) {
        return code == ExitCode.FAILED_WITH_ERRORS.getCode() || code == ExitCode.FAILED_WITH_EXCEPTIONS.getCode() || code == ExitCode.FAILED_WITH_CONFIG_ERRORS.getCode();
    }

    public String getName() {
        return "MXMLC";
    }

    public int execute(String[] args) {
        return this.mainNoExit(args);
    }

    public int mainNoExit(String[] args) {
        return this.mainNoExit(args, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainNoExit(String[] args, OutputStream err) {
        this.startTime = System.nanoTime();
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            boolean legacyOutput = this.config.useLegacyMessageFormat();
            CompilerProblemCategorizer categorizer = null;
            if (legacyOutput) {
                categorizer = this.createProblemCategorizer();
            }
            WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, categorizer);
            ProblemPrinter printer = new ProblemPrinter(formatter, err);
            if (continueCompilation) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                    System.out.println("Configuration is ok");
                }
                this.project.setProblems(this.problems.getProblems());
                this.compile();
                exitCode = this.printProblems(printer, legacyOutput);
                this.reportTargetCompletion();
            } else if (this.problems.hasFilteredProblems()) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                    System.out.println("Failed with config errors");
                }
                printer.printProblems(this.problems.getFilteredProblems());
                exitCode = ExitCode.FAILED_WITH_CONFIG_ERRORS;
            } else {
                exitCode = ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("Failed with exceptions");
            }
            PrintStream printStream = new PrintStream(err);
            printStream.println(e.getMessage());
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        finally {
            if (!this.config.getWatch() || !ExitCode.SUCCESS.equals((Object)exitCode)) {
                this.waitAndClose();
            }
        }
        if (this.config.getWatch() && ExitCode.SUCCESS.equals((Object)exitCode)) {
            this.setupWatcher();
            exitCode = ExitCode.WATCHING;
        }
        return exitCode.getCode();
    }

    protected void setupWatcher() {
        if (!this.config.getWatch()) {
            return;
        }
        WatchThread.IWatchWriter writer = new WatchThread.IWatchWriter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rebuild(Collection<ICompilationUnit> units, Collection<ICompilerProblem> problems) throws InterruptedException, IOException {
                MXMLC.this.startTime = System.nanoTime();
                MXMLC.this.workspace.startBuilding();
                try {
                    if (!MXMLC.this.setupTargetFile()) {
                        throw new IOException("Failed to setup target file.");
                    }
                    MXMLC.this.buildArtifact();
                    for (ICompilationUnit unit : units) {
                        unit.waitForBuildFinish(problems, null);
                    }
                }
                finally {
                    MXMLC.this.workspace.doneBuilding();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(Collection<ICompilationUnit> units) throws InterruptedException, IOException {
                MXMLC.this.workspace.startBuilding();
                try {
                    File outputFile = new File(MXMLC.this.getOutputFilePath());
                    int swfSize = MXMLC.this.writeSWF(MXMLC.this.swfTarget, outputFile);
                    long endTime = System.nanoTime();
                    String seconds = String.format("%5.3f", (double)(endTime - MXMLC.this.startTime) / 1.0E9);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("byteCount", swfSize);
                    params.put("path", outputFile.getCanonicalPath());
                    params.put("seconds", seconds);
                    MXMLC.this.swfOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
                    MXMLC.this.reportTargetCompletion();
                }
                finally {
                    MXMLC.this.workspace.doneBuilding();
                }
            }
        };
        WatchThread watcherThread = new WatchThread("SWF", writer, this.config, this.project, this.workspace, this.problems);
        watcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainCompileOnly(String[] args, OutputStream err) {
        if (err == null) {
            err = System.err;
        }
        this.startTime = System.nanoTime();
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            boolean legacyOutput = this.config.useLegacyMessageFormat();
            CompilerProblemCategorizer categorizer = null;
            if (legacyOutput) {
                categorizer = this.createProblemCategorizer();
            }
            WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, categorizer);
            ProblemPrinter printer = new ProblemPrinter(formatter, err);
            if (continueCompilation) {
                this.compile(true);
                exitCode = this.printProblems(printer, legacyOutput);
                this.reportTargetCompletion();
            } else if (this.problems.hasFilteredProblems()) {
                printer.printProblems(this.problems.getFilteredProblems());
                exitCode = ExitCode.FAILED_WITH_CONFIG_ERRORS;
            } else {
                exitCode = ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            PrintStream printStream = new PrintStream(err);
            printStream.println(e.getMessage());
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        finally {
            this.waitAndClose();
        }
        return exitCode.getCode();
    }

    private ExitCode printProblems(ProblemPrinter printer, boolean legacyOutput) {
        ExitCode exitCode = ExitCode.SUCCESS;
        if (legacyOutput) {
            if (printer.printProblems(this.problems.getFilteredProblems()) > 0 && this.problems.hasErrors()) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        } else {
            ArrayList<ICompilerProblem> errors = new ArrayList<ICompilerProblem>();
            ArrayList<ICompilerProblem> warnings = new ArrayList<ICompilerProblem>();
            this.problems.getErrorsAndWarnings(errors, warnings);
            int errorCount = errors.size();
            int warningCount = warnings.size();
            if (warningCount > 0) {
                System.err.println(Messages.getString("MXMLC.WarningsHeader"));
                printer.printProblems(warnings);
            }
            if (errorCount > 0) {
                System.err.println(Messages.getString("MXMLC.ErrorsHeader"));
                printer.printProblems(errors);
            }
            if (errorCount == 1) {
                System.err.println(Messages.getString("MXMLC.1_error"));
            } else if (errorCount > 0) {
                System.err.println(Messages.getString("MXMLC.multiple_errors_format", Collections.singletonMap("errorCount", errors.size())));
            }
            if (warningCount == 1) {
                System.err.println(Messages.getString("MXMLC.1_warning"));
            } else if (warningCount > 0) {
                System.err.println(Messages.getString("MXMLC.multiple_warnings_format", Collections.singletonMap("warningCount", warnings.size())));
            }
            if (errorCount > 0) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        }
        return exitCode;
    }

    public void println(String msg) {
        System.out.println(msg);
    }

    protected void waitAndClose() {
        this.workspace.startIdleState();
        try {
            this.workspace.close();
        }
        finally {
            this.workspace.endIdleState(Collections.emptyMap());
        }
    }

    protected void close() {
        this.workspace.close();
    }

    protected Configurator createConfigurator() {
        return new RoyaleProjectConfigurator(this.configurationClass);
    }

    public boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        try {
            if (args.length == 0) {
                String usage = CommandLineConfigurator.brief(this.getProgramName(), DEFAULT_VAR, LocalizationManager.get(), L10N_CONFIG_PREFIX);
                this.println(this.getStartMessage());
                if (usage != null) {
                    this.println(usage);
                }
                this.config = new Configuration();
                this.configBuffer = new ConfigurationBuffer(Configuration.class, Configuration.getAliases());
                return false;
            }
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            this.projectConfigurator.setConfigurationPathResolver(resolver);
            this.projectConfigurator.setWarnOnRoyaleOnlyOptionUsage(false);
            if (this.useFlashBuilderProjectFiles(args)) {
                this.projectConfigurator.setConfiguration(FlashBuilderConfigurator.computeFlashBuilderArgs(args, this.getTargetType().getExtension()), this.getConfigurationDefaultVariable());
            } else {
                this.projectConfigurator.setConfiguration(args, this.getConfigurationDefaultVariable());
            }
            this.projectConfigurator.applyToProject(this.project);
            this.getTargetSettings();
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.config = this.projectConfigurator.getConfiguration();
            Messages.setLocale(this.config.getToolsLocale());
            this.project.apiReportFile = this.config.getApiReport();
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.problems.addAll(this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                this.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                return false;
            }
            for (String fileName : this.projectConfigurator.getLoadedConfigurationFiles()) {
                this.println(Messages.getString("MXMLC.Loading_configuration_format", Collections.singletonMap("configurationName", fileName)));
            }
            this.println("");
            if (this.config.isVerbose()) {
                for (IFileSpecification themeFile : this.project.getThemeFiles()) {
                    this.println(Messages.getString("MXMLC.Found_theme_file_format", Collections.singletonMap("themePath", themeFile.getPath())));
                }
            }
            if (this.problems.hasErrors()) {
                return false;
            }
            this.validateTargetFile();
            DefinitionBase.setPerformanceCachingEnabled(!this.config.getWatch());
            return true;
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            this.problems.add(problem);
            return false;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add(problem);
            return false;
        }
    }

    protected String getConfigurationDefaultVariable() {
        return DEFAULT_VAR;
    }

    private boolean useFlashBuilderProjectFiles(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-fb") && !arg.equals("-use-flashbuilder-project-files")) continue;
            return true;
        }
        return false;
    }

    protected void validateTargetFile() throws ConfigurationException {
        if (this.mainCU instanceof ResourceModuleCompilationUnit) {
            return;
        }
        String targetFile = this.config.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        File file = new File(targetFile);
        if (!file.exists()) {
            throw new ConfigurationException.IOError(targetFile);
        }
    }

    protected boolean compile() {
        return this.compile(false);
    }

    private boolean compile(boolean skipLinking) {
        boolean compilationSuccess = false;
        try {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("Setting up target file");
            }
            if (!this.setupTargetFile()) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                    System.out.println("Could not set up target file");
                }
                return false;
            }
            if (this.config.isDumpAst()) {
                this.dumpAST();
            }
            this.buildArtifact();
            this.project.generateAPIReport();
            if (this.swfTarget == null) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                    System.out.println("No swftarget");
                }
                return false;
            }
            if (!this.config.getCreateTargetWithErrors() && this.problems.hasErrors()) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                    System.out.println("got errors creating target");
                }
                return false;
            }
            if (skipLinking) {
                return true;
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("attempting to write output");
            }
            File outputFile = new File(this.getOutputFilePath());
            int swfSize = this.writeSWF(this.swfTarget, outputFile);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("byteCount", swfSize);
            params.put("path", outputFile.getCanonicalPath());
            params.put("seconds", seconds);
            this.swfOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
            this.dumpDependencyGraphIfNeeded();
            compilationSuccess = true;
        }
        catch (IOException e) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("got IOException in compile()");
            }
            FileIOProblem problem = new FileIOProblem(e);
            this.problems.add(problem);
        }
        catch (Exception e) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("got Exception in compile()");
            }
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add(problem);
        }
        return compilationSuccess;
    }

    protected void setupThemeFiles() {
        this.project.setThemeFiles(MXMLC.toFileSpecifications(this.config.getCompilerThemeFiles(), this.workspace));
        if (this.config.isVerbose()) {
            for (IFileSpecification themeFile : this.project.getThemeFiles()) {
                this.verboseMessage(Messages.getString("MXMLC.Found_theme_file_format", Collections.singletonMap("themePath", themeFile.getPath())));
            }
        }
    }

    protected void reportTargetCompletion() throws InterruptedException {
        if (this.swfOutputMessage != null) {
            this.reportRequiredRSLs(this.target);
            this.println(this.swfOutputMessage);
        }
    }

    private CompilerProblemCategorizer createProblemCategorizer() {
        ICompilerProblemSettings problemSettings = null;
        try {
            problemSettings = this.projectConfigurator.getCompilerProblemSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CompilerProblemCategorizer(problemSettings);
    }

    private void dumpAST() throws InterruptedException {
        ArrayList<String> astDump = new ArrayList<String>();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        ImmutableList<ICompilationUnit> compilationUnits = this.target.getReachableCompilationUnits(problems);
        for (ICompilationUnit compilationUnit : compilationUnits) {
            IASNode ast = compilationUnit.getSyntaxTreeRequest().get().getAST();
            if (ast == null) continue;
            if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                System.out.println("MXMLC waiting for lock in populateFunctionNodes");
            }
            ((IFileNode)ast).populateFunctionNodes();
            if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                System.out.println("MXMLC done with lock in populateFunctionNodes");
            }
            astDump.add(ast.toString());
        }
        this.println(Joiner.on((String)"\n\n").join(astDump));
    }

    protected void buildArtifact() throws InterruptedException, IOException {
        this.swfTarget = this.buildSWFModel();
    }

    private ISWF buildSWFModel() throws InterruptedException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        ISWF swf = this.target.build(problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (swf == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add(problem);
        }
        return swf;
    }

    private void reportRequiredRSLs(ISWFTarget target) throws InterruptedException {
        if (this.hasRSLs()) {
            ITargetReport report = target.getTargetReport();
            if (report == null) {
                return;
            }
            List<RSLSettings> requiredRSLs = report.getRequiredRSLs();
            List<String> legacyRSLs = this.targetSettings.getRuntimeSharedLibraries();
            if (requiredRSLs.isEmpty() && legacyRSLs.isEmpty()) {
                return;
            }
            this.println(Messages.getString("MXMLC.Required_RSLs"));
            block5: for (RSLSettings rslSettings : requiredRSLs) {
                List<RSLSettings.RSLAndPolicyFileURLPair> rslURLs = rslSettings.getRSLURLs();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("rslPath", rslURLs.get(0).getRSLURL());
                switch (rslURLs.size()) {
                    case 0: {
                        assert (false);
                        continue block5;
                    }
                    case 1: {
                        this.println(Messages.getString("MXMLC.required_rsl_url_format", params));
                        continue block5;
                    }
                    case 2: {
                        this.println(Messages.getString("MXMLC.required_rsl_url_with_1_failover_format", params));
                        continue block5;
                    }
                }
                params.put("failoverCount", rslURLs.size() - 1);
                this.println(Messages.getString("MXMLC.required_rsl_url_with_multiple_failovers_format", params));
            }
            for (String rslURL : legacyRSLs) {
                this.println(Messages.getString("MXMLC.required_rsl_url_format", Collections.singletonMap("rslPath", rslURL)));
            }
        }
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        return this.targetSettings;
    }

    private boolean hasRSLs() {
        return this.getTargetSettings().getRuntimeSharedLibraryPath().size() > 0 || this.getTargetSettings().getRuntimeSharedLibraryPath().size() > 0;
    }

    private int writeSWF(ISWF swf, File outputFile) throws IOException {
        Header.Compression compression = Header.decideCompression(this.targetSettings.useCompression(), this.targetSettings.getSWFVersion(), this.targetSettings.isDebugEnabled());
        ISWFWriterFactory writerFactory = SizeReportWritingSWFWriter.getSWFWriterFactory(this.targetSettings.getSizeReport());
        ISWFWriter writer = writerFactory.createSWFWriter(swf, compression, this.targetSettings.isDebugEnabled(), this.targetSettings.isTelemetryEnabled());
        return writer.writeTo(outputFile);
    }

    protected boolean setupTargetFile() throws InterruptedException {
        String mainFileName = this.config.getTargetFile();
        if (mainFileName != null) {
            String normalizedMainFileName = FilenameNormalization.normalize(mainFileName);
            if (mainFileName.toLowerCase().endsWith(".css")) {
                this.mainCU = new StyleModuleCompilationUnit(this.project, this.workspace.getFileSpecification(normalizedMainFileName), DefinitionPriority.BasePriority.SOURCE_LIST);
                this.config.setMainDefinition("CSSModule2Main");
                this.project.addCompilationUnitsAndUpdateDefinitions(Collections.singleton(this.mainCU));
            } else {
                File normalizedMainFile;
                SourceCompilationUnitFactory compilationUnitFactory = this.project.getSourceCompilationUnitFactory();
                if (compilationUnitFactory.canCreateCompilationUnit(normalizedMainFile = new File(normalizedMainFileName))) {
                    this.project.removeSourceFile(normalizedMainFile);
                    this.project.addIncludeSourceFile(normalizedMainFile, true);
                    Collection<ICompilationUnit> mainFileCompilationUnits = this.workspace.getCompilationUnits(normalizedMainFileName, this.project);
                    assert (mainFileCompilationUnits.size() == 1);
                    this.mainCU = (ICompilationUnit)Iterables.getOnlyElement(mainFileCompilationUnits);
                }
            }
        } else {
            ArrayList<ICompilerProblem> resourceBundleProblems = new ArrayList<ICompilerProblem>();
            Collection<ICompilationUnit> includedResourceBundles = this.target.getIncludedResourceBundlesCompilationUnits(resourceBundleProblems);
            this.problems.addAll(resourceBundleProblems);
            if (includedResourceBundles.size() > 0) {
                this.mainCU = new ResourceModuleCompilationUnit((CompilerProject)this.project, "GeneratedResourceModule", includedResourceBundles, DefinitionPriority.BasePriority.SOURCE_LIST);
                this.config.setMainDefinition("GeneratedResourceModule");
                this.project.addCompilationUnitsAndUpdateDefinitions(Collections.singleton(this.mainCU));
            }
        }
        Preconditions.checkNotNull((Object)this.mainCU, (Object)"Main compilation unit can't be null");
        if (this.getTargetSettings() == null) {
            return false;
        }
        this.target = (SWFTarget)this.project.createSWFTarget(this.getTargetSettings(), null);
        return true;
    }

    protected void setupLocaleSettings() {
        this.project.setLocales(this.config.getCompilerLocales());
        this.project.setLocaleDependentResources(this.config.getLocaleDependentSources());
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            return FilenameUtils.removeExtension((String)this.config.getTargetFile()).concat(SWF_EXT);
        }
        return this.config.getOutput();
    }

    private void verboseMessage(String s) {
        if (this.config.isVerbose()) {
            this.println(s);
        }
    }

    public static List<File> toFiles(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(new File(path));
        }
        return result;
    }

    public static List<IFileSpecification> toFileSpecifications(List<String> paths, final Workspace workspace) {
        return Lists.transform(paths, (Function)new Function<String, IFileSpecification>(){

            public IFileSpecification apply(String path) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                    System.out.println("MXMLC waiting for lock in toFileSpecifications");
                }
                IFileSpecification ret = workspace.getFileSpecification(path);
                if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                    System.out.println("MXMLC waiting for lock in toFileSpecifications");
                }
                return ret;
            }
        });
    }

    protected String getProgramName() {
        return "mxmlc";
    }

    protected String getStartMessage() {
        String message = "Apache Royale MXML and ActionScript Compiler (mxmlc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            Iterator<String> iterator = val.getArgs().iterator();
            while (iterator.hasNext()) {
                String element;
                String keyword = element = iterator.next();
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected boolean isCompc() {
        return false;
    }

    private void dumpDependencyGraphIfNeeded() throws IOException, InterruptedException {
        File dependencyGraphOutput = this.config.getDependencyGraphOutput();
        if (dependencyGraphOutput != null) {
            LinkageChecker linkageChecker = new LinkageChecker(this.project, this.getTargetSettings());
            Target.RootedCompilationUnits rootedCompilationUnits = this.target.getRootedCompilationUnits();
            this.problems.addAll(rootedCompilationUnits.getProblems());
            GraphMLWriter dependencyGraphWriter = new GraphMLWriter(this.project.getDependencyGraph(), rootedCompilationUnits.getUnits(), true, linkageChecker);
            BufferedOutputStream graphStream = new BufferedOutputStream(new FileOutputStream(dependencyGraphOutput));
            LinkedList<ICompilerProblem> problemList = new LinkedList<ICompilerProblem>();
            Iterables.addAll(problemList, rootedCompilationUnits.getProblems());
            dependencyGraphWriter.writeToStream(graphStream, problemList);
            this.problems.addAll(problemList);
        }
    }

    public ProblemQuery getProblems() {
        return this.problems;
    }

    public List<String> getSourceList() {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<ICompilerProblem> problemList = new LinkedList<ICompilerProblem>();
        try {
            ImmutableList<ICompilationUnit> units = this.target.getReachableCompilationUnits(problemList);
            for (ICompilationUnit unit : units) {
                ICompilationUnit.UnitType ut = unit.getCompilationUnitType();
                if (ut != ICompilationUnit.UnitType.AS_UNIT && ut != ICompilationUnit.UnitType.MXML_UNIT) continue;
                list.add(unit.getAbsoluteFilename());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getMainSource() {
        if (this.mainCU == null) {
            return "";
        }
        return this.mainCU.getAbsoluteFilename();
    }

    public ISWF getSWFTarget() {
        return this.swfTarget;
    }

    public int writeSWF(OutputStream outputStream) {
        Header.Compression compression = Header.decideCompression(this.targetSettings.useCompression(), this.targetSettings.getSWFVersion(), this.targetSettings.isDebugEnabled());
        ISWFWriterFactory writerFactory = SizeReportWritingSWFWriter.getSWFWriterFactory(this.targetSettings.getSizeReport());
        ISWFWriter writer = writerFactory.createSWFWriter(this.swfTarget, compression, this.targetSettings.isDebugEnabled(), this.targetSettings.isTelemetryEnabled());
        CountingOutputStream output = new CountingOutputStream(outputStream);
        writer.writeTo((OutputStream)output);
        int swfSize = output.getCount();
        return swfSize;
    }

    public static final class ExitCode
    extends Enum<ExitCode> {
        public static final /* enum */ ExitCode SUCCESS = new ExitCode(0);
        public static final /* enum */ ExitCode PRINT_HELP = new ExitCode(1);
        public static final /* enum */ ExitCode FAILED_WITH_ERRORS = new ExitCode(2);
        public static final /* enum */ ExitCode FAILED_WITH_EXCEPTIONS = new ExitCode(3);
        public static final /* enum */ ExitCode FAILED_WITH_CONFIG_ERRORS = new ExitCode(4);
        public static final /* enum */ ExitCode WATCHING = new ExitCode(1000);
        final int code;
        private static final /* synthetic */ ExitCode[] $VALUES;

        public static ExitCode[] values() {
            return (ExitCode[])$VALUES.clone();
        }

        public static ExitCode valueOf(String name) {
            return Enum.valueOf(ExitCode.class, name);
        }

        private ExitCode(int code) {
            assert (code >= 0) : "Exit code must be non-negative";
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        private static /* synthetic */ ExitCode[] $values() {
            return new ExitCode[]{SUCCESS, PRINT_HELP, FAILED_WITH_ERRORS, FAILED_WITH_EXCEPTIONS, FAILED_WITH_CONFIG_ERRORS, WATCHING};
        }

        static {
            $VALUES = ExitCode.$values();
        }
    }
}

