/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter;

import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.parsing.IMXMLToken;

public class MXMLTokenQuery {
    public static final int TOKEN_TYPE_FORMATTING = 999999;
    private IMXMLToken[] allTokens;

    public MXMLTokenQuery(IMXMLToken[] tokens) {
        this.allTokens = tokens;
    }

    public IMXMLToken[] getTokens() {
        return this.allTokens;
    }

    public IMXMLToken getTokenBefore(ISourceLocation sourceLocation) {
        return this.getTokenBefore(sourceLocation, false, false);
    }

    public IMXMLToken getTokenBefore(ISourceLocation sourceLocation, boolean skipComments, boolean skipFormatting) {
        IMXMLToken result = null;
        for (IMXMLToken token : this.allTokens) {
            if (skipComments && this.isComment(token) || skipFormatting && this.isFormatting(token)) continue;
            if (token.getStart() >= sourceLocation.getAbsoluteStart()) {
                return result;
            }
            result = token;
        }
        return result;
    }

    public IMXMLToken getTokenAfter(ISourceLocation sourceLocation) {
        return this.getTokenAfter(sourceLocation, false, false);
    }

    public IMXMLToken getTokenAfter(ISourceLocation sourceLocation, boolean skipComments, boolean skipFormatting) {
        for (IMXMLToken token : this.allTokens) {
            if (token.getStart() < sourceLocation.getAbsoluteEnd() || skipComments && this.isComment(token) || skipFormatting && this.isFormatting(token)) continue;
            return token;
        }
        return null;
    }

    public boolean isComment(IMXMLToken token) {
        return token.getMXMLTokenKind() == IMXMLToken.MXMLTokenKind.COMMENT;
    }

    public IMXMLToken getCommentBefore(ISourceLocation before) {
        IMXMLToken result = null;
        for (IMXMLToken token : this.allTokens) {
            if (token.getStart() >= before.getAbsoluteStart()) {
                return result;
            }
            if (!this.isComment(token)) continue;
            result = token;
        }
        return result;
    }

    public IMXMLToken getCommentAfter(ISourceLocation after) {
        for (IMXMLToken token : this.allTokens) {
            if (token.getStart() < after.getAbsoluteEnd() || !this.isComment(token)) continue;
            return token;
        }
        return null;
    }

    public boolean isFormatting(IMXMLToken token) {
        return token.getType() == 999999;
    }

    public IMXMLToken getFormattingBefore(ISourceLocation before) {
        IMXMLToken result = null;
        for (IMXMLToken token : this.allTokens) {
            if (token.getStart() >= before.getAbsoluteStart()) {
                return result;
            }
            if (!this.isFormatting(token)) continue;
            result = token;
        }
        return result;
    }

    public IMXMLToken getFormattingAfter(ISourceLocation after) {
        for (IMXMLToken token : this.allTokens) {
            if (token.getStart() < after.getAbsoluteEnd() || !this.isFormatting(token)) continue;
            return token;
        }
        return null;
    }

    public IMXMLToken getSignificantTokenBefore(ISourceLocation before) {
        return this.getTokenBefore(before, true, true);
    }

    public IMXMLToken getSignificantTokenAfter(ISourceLocation after) {
        return this.getTokenAfter(after, true, true);
    }
}

