/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class ClassNameRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^[A-Z][a-zA-Z0-9]*$");
    public Pattern pattern;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ClassID, (node, tokenQuery, problems) -> this.checkClassNode((IClassNode)node, tokenQuery, problems));
        return result;
    }

    private void checkClassNode(IClassNode classNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        String className = classNode.getName();
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(className)).matches()) {
            return;
        }
        problems.add(new ClassNameLinterProblem(classNode, thePattern));
    }

    public static class ClassNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Class name does not match the pattern '${pattern}'";
        public String pattern;

        public ClassNameLinterProblem(IClassNode node, Pattern pattern) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.pattern = pattern.toString();
        }
    }
}

