/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;

final class GatherGettersAndSetterProperties
implements CompilerPass {
    private final AbstractCompiler compiler;

    GatherGettersAndSetterProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        GatherGettersAndSetterProperties.update(this.compiler, externs, root);
    }

    static void update(AbstractCompiler compiler, Node externs, Node root) {
        compiler.setExternGetterAndSetterProperties(GatherGettersAndSetterProperties.gather(compiler, externs));
        compiler.setSourceGetterAndSetterProperties(GatherGettersAndSetterProperties.gather(compiler, root));
    }

    static ImmutableMap<String, AbstractCompiler.PropertyAccessKind> gather(AbstractCompiler compiler, Node root) {
        GatherCallback gatherCallback = new GatherCallback();
        NodeTraversal.traverse(compiler, root, gatherCallback);
        return ImmutableMap.copyOf(gatherCallback.properties);
    }

    private static final class GatherCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final LinkedHashMap<String, AbstractCompiler.PropertyAccessKind> properties = new LinkedHashMap();

        private GatherCallback() {
        }

        private void record(String property, AbstractCompiler.PropertyAccessKind kind) {
            this.properties.merge(property, kind, AbstractCompiler.PropertyAccessKind::unionWith);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETTER_DEF: {
                    this.recordGetterDef(n);
                    break;
                }
                case SETTER_DEF: {
                    this.recordSetterDef(n);
                    break;
                }
                case CALL: {
                    if (NodeUtil.isObjectDefinePropertyDefinition(n)) {
                        this.visitDefineProperty(n);
                        break;
                    }
                    if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) break;
                    this.visitDefineProperties(n);
                    break;
                }
            }
        }

        private void recordGetterDef(Node getterDef) {
            Preconditions.checkState(getterDef.isGetterDef());
            String name = getterDef.getString();
            this.record(name, AbstractCompiler.PropertyAccessKind.GETTER_ONLY);
        }

        private void recordSetterDef(Node setterDef) {
            Preconditions.checkState(setterDef.isSetterDef());
            String name = setterDef.getString();
            this.record(name, AbstractCompiler.PropertyAccessKind.SETTER_ONLY);
        }

        private void visitDescriptor(String propertyName, Node descriptor) {
            for (Node key : descriptor.children()) {
                if (!key.isStringKey() && !key.isMemberFunctionDef()) continue;
                if ("get".equals(key.getString())) {
                    this.record(propertyName, AbstractCompiler.PropertyAccessKind.GETTER_ONLY);
                    continue;
                }
                if (!"set".equals(key.getString())) continue;
                this.record(propertyName, AbstractCompiler.PropertyAccessKind.SETTER_ONLY);
            }
        }

        private void visitDefineProperty(Node definePropertyCall) {
            Node propertyNameNode = definePropertyCall.getChildAtIndex(2);
            Node descriptor = definePropertyCall.getChildAtIndex(3);
            if (!propertyNameNode.isString() || !descriptor.isObjectLit()) {
                return;
            }
            String propertyName = propertyNameNode.getString();
            this.visitDescriptor(propertyName, descriptor);
        }

        private void visitDefineProperties(Node definePropertiesCall) {
            Node props = definePropertiesCall.getChildAtIndex(2);
            if (!props.isObjectLit()) {
                return;
            }
            for (Node prop : props.children()) {
                if (!prop.isStringKey() || !prop.hasOneChild() || !prop.getFirstChild().isObjectLit()) continue;
                String propertyName = prop.getString();
                Node descriptor = prop.getFirstChild();
                this.visitDescriptor(propertyName, descriptor);
            }
        }
    }
}

