/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.PlayerSession;
import flash.util.FieldFormat;
import flash.util.Trace;
import java.io.UnsupportedEncodingException;

public class DMessage {
    public static final int InUnknown = -1;
    public static final int InSetMenuState = 0;
    public static final int InSetProperty = 1;
    public static final int InExit = 2;
    public static final int InNewObject = 3;
    public static final int InRemoveObject = 4;
    public static final int InTrace = 5;
    public static final int InErrorTarget = 6;
    public static final int InErrorExecLimit = 7;
    public static final int InErrorWith = 8;
    public static final int InErrorProtoLimit = 9;
    public static final int InSetVariable = 10;
    public static final int InDeleteVariable = 11;
    public static final int InParam = 12;
    public static final int InPlaceObject = 13;
    public static final int InScript = 14;
    public static final int InAskBreakpoints = 15;
    public static final int InBreakAt = 16;
    public static final int InContinue = 17;
    public static final int InSetLocalVariables = 18;
    public static final int InSetBreakpoint = 19;
    public static final int InNumScript = 20;
    public static final int InRemoveScript = 21;
    public static final int InRemoveBreakpoint = 22;
    public static final int InNotSynced = 23;
    public static final int InErrorURLOpen = 24;
    public static final int InProcessTag = 25;
    public static final int InVersion = 26;
    public static final int InBreakAtExt = 27;
    public static final int InSetVariable2 = 28;
    public static final int InSquelch = 29;
    public static final int InGetVariable = 30;
    public static final int InFrame = 31;
    public static final int InOption = 32;
    public static final int InWatch = 33;
    public static final int InGetSwf = 34;
    public static final int InGetSwd = 35;
    public static final int InErrorException = 36;
    public static final int InErrorStackUnderflow = 37;
    public static final int InErrorZeroDivide = 38;
    public static final int InErrorScriptStuck = 39;
    public static final int InBreakReason = 40;
    public static final int InGetActions = 41;
    public static final int InSwfInfo = 42;
    public static final int InConstantPool = 43;
    public static final int InErrorConsole = 44;
    public static final int InGetFncNames = 45;
    public static final int InCallFunction = 54;
    public static final int InWatch2 = 55;
    public static final int InPassAllExceptionsToDebugger = 56;
    public static final int InBinaryOp = 57;
    public static final int InIsolateCreate = 58;
    public static final int InIsolateExit = 59;
    public static final int InIsolateEnumerate = 60;
    public static final int InSetActiveIsolate = 61;
    public static final int InIsolate = 62;
    public static final int InSetExceptionBreakpoint = 63;
    public static final int InRemoveExceptionBreakpoint = 64;
    public static final int InSIZE = 65;
    public static final int OutUnknown = -2;
    public static final int OutZoomIn = 0;
    public static final int OutZoomOut = 1;
    public static final int OutZoom100 = 2;
    public static final int OutHome = 3;
    public static final int OutSetQuality = 4;
    public static final int OutPlay = 5;
    public static final int OutLoop = 6;
    public static final int OutRewind = 7;
    public static final int OutForward = 8;
    public static final int OutBack = 9;
    public static final int OutPrint = 10;
    public static final int OutSetVariable = 11;
    public static final int OutSetProperty = 12;
    public static final int OutExit = 13;
    public static final int OutSetFocus = 14;
    public static final int OutContinue = 15;
    public static final int OutStopDebug = 16;
    public static final int OutSetBreakpoints = 17;
    public static final int OutRemoveBreakpoints = 18;
    public static final int OutRemoveAllBreakpoints = 19;
    public static final int OutStepOver = 20;
    public static final int OutStepInto = 21;
    public static final int OutStepOut = 22;
    public static final int OutProcessedTag = 23;
    public static final int OutSetSquelch = 24;
    public static final int OutGetVariable = 25;
    public static final int OutGetFrame = 26;
    public static final int OutGetOption = 27;
    public static final int OutSetOption = 28;
    public static final int OutAddWatch = 29;
    public static final int OutRemoveWatch = 30;
    public static final int OutStepContinue = 31;
    public static final int OutGetSwf = 32;
    public static final int OutGetSwd = 33;
    public static final int OutGetVariableWhichInvokesGetter = 34;
    public static final int OutGetBreakReason = 35;
    public static final int OutGetActions = 36;
    public static final int OutSetActions = 37;
    public static final int OutSwfInfo = 38;
    public static final int OutConstantPool = 39;
    public static final int OutGetFncNames = 40;
    public static final int OutCallFunction = 48;
    public static final int OutAddWatch2 = 49;
    public static final int OutRemoveWatch2 = 50;
    public static final int OutPassAllExceptionsToDebugger = 51;
    public static final int OutBinaryOp = 52;
    public static final int OutIsolateEnumerate = 53;
    public static final int OutSetActiveIsolate = 54;
    public static final int OutSetExceptionBreakpoint = 55;
    public static final int OutRemoveExceptionBreakpoint = 56;
    public static final int OutSIZE = 57;
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    public static final int kNamespaceType = 18;
    public static final int kTraitsType = 19;
    byte[] m_content;
    int m_index;
    int m_type;
    private static int m_sizeofPtr;
    private StringBuilder m_debugFormatted;
    private int m_debugFormattedThroughIndex;
    private int m_targetIsolate;

    public DMessage(int n) {
        this.m_content = new byte[n];
        this.m_debugFormatted = new StringBuilder();
        this.m_debugFormattedThroughIndex = 0;
        this.m_targetIsolate = 1;
        this.clear();
    }

    public int getType() {
        return this.m_type;
    }

    public String getInTypeName() {
        return DMessage.inTypeName(this.getType());
    }

    public String getOutTypeName() {
        return DMessage.outTypeName(this.getType());
    }

    public byte[] getData() {
        return this.m_content;
    }

    public int getSize() {
        return this.m_content == null ? 0 : this.m_content.length;
    }

    public int getRemaining() {
        return this.getSize() - this.m_index;
    }

    public int getPosition() {
        return this.m_index;
    }

    public int getTargetIsolate() {
        return this.m_targetIsolate;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public void setTargetIsolate(int n) {
        this.m_targetIsolate = n;
    }

    public static int getSizeofPtr() {
        assert (m_sizeofPtr != 0);
        return m_sizeofPtr;
    }

    public static void setSizeofPtr(int n) {
        assert (n != 0);
        m_sizeofPtr = n;
    }

    public void reset() {
        this.m_index = 0;
    }

    public void clear() {
        this.setType(-1);
        this.setTargetIsolate(1);
        this.m_debugFormatted.setLength(0);
        this.m_debugFormattedThroughIndex = 0;
        this.reset();
    }

    private long get(int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + n > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + n);
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = this.m_content[this.m_index++] & 0xFF;
            long l3 = l2 << 8 * i;
            l |= l3;
        }
        this.debugAppendNumber(l, n);
        return l;
    }

    public int getByte() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(1);
    }

    public int getWord() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(2);
    }

    public long getDWord() throws ArrayIndexOutOfBoundsException {
        return this.get(4);
    }

    public long getLong() throws ArrayIndexOutOfBoundsException {
        return this.get(8);
    }

    public long getPtr() throws ArrayIndexOutOfBoundsException {
        return this.get(DMessage.getSizeofPtr());
    }

    public String getString() throws ArrayIndexOutOfBoundsException {
        String string;
        int n = this.m_index;
        boolean bl = false;
        while (!bl) {
            byte by;
            if ((by = this.m_content[this.m_index++]) == 0) {
                bl = true;
                continue;
            }
            if (this.m_index <= this.m_content.length) continue;
            throw new ArrayIndexOutOfBoundsException("no string terminator found @" + this.m_index);
        }
        try {
            string = new String(this.m_content, n, this.m_index - n - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.m_content, n, this.m_index - n - 1);
        }
        this.debugAppendString(string);
        return string;
    }

    public void put(long l, int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + n > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_content[this.m_index++] = (byte)(l >> 8 * i);
        }
        this.debugAppendNumber(l, n);
    }

    public void putByte(byte by) throws ArrayIndexOutOfBoundsException {
        this.put(by, 1);
    }

    public void putWord(int n) throws ArrayIndexOutOfBoundsException {
        this.put(n, 2);
    }

    public void putDWord(int n) throws ArrayIndexOutOfBoundsException {
        this.put(n, 4);
    }

    public void putLong(long l) throws ArrayIndexOutOfBoundsException {
        this.put(l, 8);
    }

    public void putPtr(long l) throws ArrayIndexOutOfBoundsException {
        this.put(l, DMessage.getSizeofPtr());
    }

    public static int getStringLength(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.error) {
                Trace.trace(unsupportedEncodingException.toString());
            }
            return 0;
        }
    }

    public void putString(String string) throws ArrayIndexOutOfBoundsException, UnsupportedEncodingException {
        byte[] byArray = string.getBytes("UTF-8");
        int n = byArray.length;
        int n2 = this.m_index + n + 1;
        if (n2 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.m_content.length);
        }
        System.arraycopy(byArray, 0, this.m_content, this.m_index, n);
        this.m_index += n;
        this.m_content[this.m_index++] = 0;
        this.debugAppendString(string);
    }

    private void debugAppendNumber(long l, int n) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("0x");
            FieldFormat.formatLongToHex(stringBuilder, l, n * 2, true);
            this.debugAppend(stringBuilder.toString());
        }
    }

    private void debugAppendString(String string) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            this.debugAppend("\"" + string + "\"");
        }
    }

    private void debugAppend(String string) {
        if ((PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) && this.m_index > this.m_debugFormattedThroughIndex) {
            this.m_debugFormattedThroughIndex = this.m_index;
            if (this.m_debugFormatted.length() > 0) {
                this.m_debugFormatted.append(' ');
            }
            this.m_debugFormatted.append(string);
        }
    }

    public String inToString() {
        return this.inToString(16);
    }

    public String inToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getInTypeName());
        stringBuilder.append('[');
        stringBuilder.append(this.getSize());
        stringBuilder.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(stringBuilder, n);
        }
        return stringBuilder.toString();
    }

    public String outToString() {
        return this.outToString(16);
    }

    public String outToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOutTypeName());
        stringBuilder.append('[');
        stringBuilder.append(this.getSize());
        stringBuilder.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(stringBuilder, n);
        }
        return stringBuilder.toString();
    }

    public StringBuilder appendContent(StringBuilder stringBuilder, int n) {
        int n2 = this.getSize();
        byte[] byArray = this.getData();
        int n3 = 0;
        stringBuilder.append((CharSequence)this.m_debugFormatted);
        for (n3 = 0; n3 < n && n3 + this.m_debugFormattedThroughIndex < n2; ++n3) {
            int n4 = byArray[n3 + this.m_debugFormattedThroughIndex] & 0xFF;
            stringBuilder.append(" 0x");
            FieldFormat.formatLongToHex(stringBuilder, n4, 2, true);
        }
        if (n3 + this.m_debugFormattedThroughIndex < n2) {
            stringBuilder.append(" ...");
        }
        return stringBuilder;
    }

    public static String inTypeName(int n) {
        Object object = "InUnknown(" + n + ")";
        switch (n) {
            case 0: {
                object = "InSetMenuState";
                break;
            }
            case 1: {
                object = "InSetProperty";
                break;
            }
            case 2: {
                object = "InExit";
                break;
            }
            case 3: {
                object = "InNewObject";
                break;
            }
            case 4: {
                object = "InRemoveObject";
                break;
            }
            case 5: {
                object = "InTrace";
                break;
            }
            case 6: {
                object = "InErrorTarget";
                break;
            }
            case 7: {
                object = "InErrorExecLimit";
                break;
            }
            case 8: {
                object = "InErrorWith";
                break;
            }
            case 9: {
                object = "InErrorProtoLimit";
                break;
            }
            case 10: {
                object = "InSetVariable";
                break;
            }
            case 11: {
                object = "InDeleteVariable";
                break;
            }
            case 12: {
                object = "InParam";
                break;
            }
            case 13: {
                object = "InPlaceObject";
                break;
            }
            case 14: {
                object = "InScript";
                break;
            }
            case 15: {
                object = "InAskBreakpoints";
                break;
            }
            case 16: {
                object = "InBreakAt";
                break;
            }
            case 17: {
                object = "InContinue";
                break;
            }
            case 18: {
                object = "InSetLocalVariables";
                break;
            }
            case 19: {
                object = "InSetBreakpoint";
                break;
            }
            case 20: {
                object = "InNumScript";
                break;
            }
            case 21: {
                object = "InRemoveScript";
                break;
            }
            case 22: {
                object = "InRemoveBreakpoint";
                break;
            }
            case 23: {
                object = "InNotSynced";
                break;
            }
            case 24: {
                object = "InErrorURLOpen";
                break;
            }
            case 25: {
                object = "InProcessTag";
                break;
            }
            case 26: {
                object = "InVersion";
                break;
            }
            case 27: {
                object = "InBreakAtExt";
                break;
            }
            case 28: {
                object = "InSetVariable2";
                break;
            }
            case 29: {
                object = "InSquelch";
                break;
            }
            case 30: {
                object = "InGetVariable";
                break;
            }
            case 31: {
                object = "InFrame";
                break;
            }
            case 32: {
                object = "InOption";
                break;
            }
            case 33: {
                object = "InWatch";
                break;
            }
            case 34: {
                object = "InGetSwf";
                break;
            }
            case 35: {
                object = "InGetSwd";
                break;
            }
            case 36: {
                object = "InErrorException";
                break;
            }
            case 37: {
                object = "InErrorStackUnderflow";
                break;
            }
            case 38: {
                object = "InErrorZeroDivide";
                break;
            }
            case 39: {
                object = "InErrorScriptStuck";
                break;
            }
            case 40: {
                object = "InBreakReason";
                break;
            }
            case 41: {
                object = "InGetActions";
                break;
            }
            case 42: {
                object = "InSwfInfo";
                break;
            }
            case 43: {
                object = "InConstantPool";
                break;
            }
            case 44: {
                object = "InErrorConsole";
                break;
            }
            case 45: {
                object = "InGetFncNames";
                break;
            }
            case 54: {
                object = "InCallFunction";
                break;
            }
            case 55: {
                object = "InWatch2";
                break;
            }
            case 56: {
                object = "InPassAllExceptionsToDebugger";
                break;
            }
            case 57: {
                object = "InBinaryOp";
                break;
            }
            case 58: {
                object = "InIsolateCreate";
                break;
            }
            case 59: {
                object = "InIsolateExit";
                break;
            }
            case 60: {
                object = "InIsolateEnumerate";
                break;
            }
            case 61: {
                object = "InSetActiveIsolate";
                break;
            }
            case 62: {
                object = "InIsolate";
                break;
            }
            case 63: {
                object = "InSetExceptionBreakpoint";
                break;
            }
            case 64: {
                object = "InRemoveExceptionBreakpoint";
            }
        }
        return object;
    }

    public static String outTypeName(int n) {
        Object object = "OutUnknown(" + n + ")";
        switch (n) {
            case 0: {
                object = "OutZoomIn";
                break;
            }
            case 1: {
                object = "OutZoomOut";
                break;
            }
            case 2: {
                object = "OutZoom100";
                break;
            }
            case 3: {
                object = "OutHome";
                break;
            }
            case 4: {
                object = "OutSetQuality";
                break;
            }
            case 5: {
                object = "OutPlay";
                break;
            }
            case 6: {
                object = "OutLoop";
                break;
            }
            case 7: {
                object = "OutRewind";
                break;
            }
            case 8: {
                object = "OutForward";
                break;
            }
            case 9: {
                object = "OutBack";
                break;
            }
            case 10: {
                object = "OutPrint";
                break;
            }
            case 11: {
                object = "OutSetVariable";
                break;
            }
            case 12: {
                object = "OutSetProperty";
                break;
            }
            case 13: {
                object = "OutExit";
                break;
            }
            case 14: {
                object = "OutSetFocus";
                break;
            }
            case 15: {
                object = "OutContinue";
                break;
            }
            case 16: {
                object = "OutStopDebug";
                break;
            }
            case 17: {
                object = "OutSetBreakpoints";
                break;
            }
            case 18: {
                object = "OutRemoveBreakpoints";
                break;
            }
            case 19: {
                object = "OutRemoveAllBreakpoints";
                break;
            }
            case 20: {
                object = "OutStepOver";
                break;
            }
            case 21: {
                object = "OutStepInto";
                break;
            }
            case 22: {
                object = "OutStepOut";
                break;
            }
            case 23: {
                object = "OutProcessedTag";
                break;
            }
            case 24: {
                object = "OutSetSquelch";
                break;
            }
            case 25: {
                object = "OutGetVariable";
                break;
            }
            case 26: {
                object = "OutGetFrame";
                break;
            }
            case 27: {
                object = "OutGetOption";
                break;
            }
            case 28: {
                object = "OutSetOption";
                break;
            }
            case 29: {
                object = "OutAddWatch";
                break;
            }
            case 30: {
                object = "OutRemoveWatch";
                break;
            }
            case 31: {
                object = "OutStepContinue";
                break;
            }
            case 32: {
                object = "OutGetSwf";
                break;
            }
            case 33: {
                object = "OutGetSwd";
                break;
            }
            case 34: {
                object = "OutGetVariableWhichInvokesGetter";
                break;
            }
            case 35: {
                object = "OutGetBreakReason";
                break;
            }
            case 36: {
                object = "OutGetActions";
                break;
            }
            case 37: {
                object = "OutSetActions";
                break;
            }
            case 38: {
                object = "OutSwfInfo";
                break;
            }
            case 39: {
                object = "OutConstantPool";
                break;
            }
            case 40: {
                object = "OutGetFncNames";
                break;
            }
            case 48: {
                object = "OutCallFunction";
                break;
            }
            case 49: {
                object = "OutAddWatch2";
                break;
            }
            case 50: {
                object = "OutRemoveWatch2";
                break;
            }
            case 51: {
                object = "OutPassAllExceptionsToDebugger";
                break;
            }
            case 52: {
                object = "OutBinaryOp";
                break;
            }
            case 53: {
                object = "OutIsolateEnumerate";
                break;
            }
            case 54: {
                object = "OutSetActiveIsolate";
                break;
            }
            case 55: {
                object = "OutSetExceptionBreakpoint";
                break;
            }
            case 56: {
                object = "OutRemoveExceptionBreakpoint";
            }
        }
        return object;
    }
}

