/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.execution;

import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.core.starter.spark.execution.PluginExecuteProcessor;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class AbstractPluginExecuteProcessor<T>
implements PluginExecuteProcessor {
    protected final SparkEnvironment sparkEnvironment;
    protected final List<? extends Config> pluginConfigs;
    protected final JobContext jobContext;
    protected final List<T> plugins;
    protected static final String ENGINE_TYPE = "seatunnel";
    protected static final String PLUGIN_NAME = "plugin_name";

    protected AbstractPluginExecuteProcessor(SparkEnvironment sparkEnvironment, JobContext jobContext, List<? extends Config> pluginConfigs) {
        this.sparkEnvironment = sparkEnvironment;
        this.jobContext = jobContext;
        this.pluginConfigs = pluginConfigs;
        this.plugins = this.initializePlugins(pluginConfigs);
    }

    protected abstract List<T> initializePlugins(List<? extends Config> var1);

    protected void registerInputTempView(Config pluginConfig, Dataset<Row> dataStream) {
        if (pluginConfig.hasPath("result_table_name")) {
            String tableName = pluginConfig.getString("result_table_name");
            this.registerTempView(tableName, dataStream);
        }
    }

    protected Optional<Dataset<Row>> fromSourceTable(Config pluginConfig, SparkEnvironment sparkEnvironment) {
        if (!pluginConfig.hasPath("source_table_name")) {
            return Optional.empty();
        }
        String sourceTableName = pluginConfig.getString("source_table_name");
        return Optional.of(sparkEnvironment.getSparkSession().read().table(sourceTableName));
    }

    private void registerTempView(String tableName, Dataset<Row> ds) {
        ds.createOrReplaceTempView(tableName);
    }
}

