/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.seatunnel.core.starter.command.AbstractCommandArgs;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static Path getConfigPath(AbstractCommandArgs args) {
        FileUtils.checkNotNull(args, "args");
        FileUtils.checkNotNull(args.getDeployMode(), "deploy mode");
        switch (args.getDeployMode()) {
            case CLIENT: {
                return Paths.get(args.getConfigFile(), new String[0]);
            }
            case CLUSTER: {
                return Paths.get(FileUtils.getFileName(args.getConfigFile()), new String[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported deploy mode: " + (Object)((Object)args.getDeployMode()));
    }

    private static String getFileName(String filePath) {
        FileUtils.checkNotNull(filePath, "file path");
        return filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
    }

    private static <T> void checkNotNull(T arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(argName + " cannot be null");
        }
    }
}

