/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.SeaTunnelRowContainerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleFieldOutputTransform
extends AbstractCatalogSupportTransform {
    private static final Logger log = LoggerFactory.getLogger(SingleFieldOutputTransform.class);
    private static final String[] TYPE_ARRAY_STRING = new String[0];
    private static final SeaTunnelDataType[] TYPE_ARRAY_SEATUNNEL_DATA_TYPE = new SeaTunnelDataType[0];
    private int fieldIndex;
    private SeaTunnelRowContainerGenerator rowContainerGenerator;

    public SingleFieldOutputTransform(@NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        this.setInputRowType(inputRowType);
        String outputFieldName = this.getOutputFieldName();
        SeaTunnelDataType outputFieldDataType = this.getOutputFieldDataType();
        LinkedList<String> fieldNames = new LinkedList<String>(Arrays.asList(inputRowType.getFieldNames()));
        LinkedList<SeaTunnelDataType> fieldDataTypes = new LinkedList<SeaTunnelDataType>(Arrays.asList(inputRowType.getFieldTypes()));
        int index = fieldNames.indexOf(outputFieldName);
        if (index != -1) {
            if (!outputFieldDataType.equals(fieldDataTypes.get(index))) {
                fieldDataTypes.set(index, outputFieldDataType);
            }
            this.fieldIndex = index;
            this.rowContainerGenerator = SeaTunnelRowContainerGenerator.REUSE_ROW;
        } else {
            fieldNames.addLast(outputFieldName);
            fieldDataTypes.addLast(outputFieldDataType);
            final int inputFieldLength = inputRowType.getTotalFields();
            final int outputFieldLength = fieldNames.size();
            this.fieldIndex = fieldNames.indexOf(outputFieldName);
            this.rowContainerGenerator = new SeaTunnelRowContainerGenerator(){

                @Override
                public SeaTunnelRow apply(SeaTunnelRow inputRow) {
                    Object[] outputFieldValues = new Object[outputFieldLength];
                    System.arraycopy(inputRow.getFields(), 0, outputFieldValues, 0, inputFieldLength);
                    SeaTunnelRow outputRow = new SeaTunnelRow(outputFieldValues);
                    outputRow.setTableId(inputRow.getTableId());
                    outputRow.setRowKind(inputRow.getRowKind());
                    return outputRow;
                }
            };
        }
        SeaTunnelRowType outputRowType = new SeaTunnelRowType(fieldNames.toArray(TYPE_ARRAY_STRING), fieldDataTypes.toArray(TYPE_ARRAY_SEATUNNEL_DATA_TYPE));
        log.info("Changed input row type: {} to output row type: {}", (Object)inputRowType, (Object)outputRowType);
        return outputRowType;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object fieldValue = this.getOutputFieldValue(new SeaTunnelRowAccessor(inputRow));
        SeaTunnelRow outputRow = (SeaTunnelRow)this.rowContainerGenerator.apply(inputRow);
        outputRow.setField(this.fieldIndex, fieldValue);
        return outputRow;
    }

    protected abstract void setInputRowType(SeaTunnelRowType var1);

    protected abstract String getOutputFieldName();

    protected abstract SeaTunnelDataType getOutputFieldDataType();

    protected abstract Object getOutputFieldValue(SeaTunnelRowAccessor var1);

    @Override
    protected TableSchema transformTableSchema() {
        Column outputColumn = this.getOutputColumn();
        List copiedConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().map(ConstraintKey::copy).collect(Collectors.toList());
        TableSchema.Builder builder = TableSchema.builder();
        if (this.inputCatalogTable.getTableSchema().getPrimaryKey() != null) {
            builder = builder.primaryKey(this.inputCatalogTable.getTableSchema().getPrimaryKey().copy());
        }
        builder = builder.constraintKey(copiedConstraintKeys);
        List columns = this.inputCatalogTable.getTableSchema().getColumns().stream().map(Column::copy).collect(Collectors.toList());
        int addFieldCount = 0;
        Optional<Column> optional = columns.stream().filter(c -> c.getName().equals(outputColumn.getName())).findFirst();
        if (optional.isPresent()) {
            Column originalColumn = optional.get();
            int originalColumnIndex = columns.indexOf(originalColumn);
            if (!originalColumn.getDataType().equals(outputColumn.getDataType())) {
                columns.set(originalColumnIndex, originalColumn.copy(outputColumn.getDataType()));
            }
            this.fieldIndex = originalColumnIndex;
        } else {
            ++addFieldCount;
            columns.add(outputColumn);
            this.fieldIndex = columns.indexOf(outputColumn);
        }
        TableSchema outputTableSchema = builder.columns(columns).build();
        if (addFieldCount > 0) {
            this.fieldIndex = outputTableSchema.getColumns().size() - 1;
            final int inputFieldLength = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType().getTotalFields();
            final int outputFieldLength = outputTableSchema.getColumns().size();
            this.rowContainerGenerator = new SeaTunnelRowContainerGenerator(){

                @Override
                public SeaTunnelRow apply(SeaTunnelRow inputRow) {
                    Object[] outputFieldValues = new Object[outputFieldLength];
                    System.arraycopy(inputRow.getFields(), 0, outputFieldValues, 0, inputFieldLength);
                    SeaTunnelRow outputRow = new SeaTunnelRow(outputFieldValues);
                    outputRow.setTableId(inputRow.getTableId());
                    outputRow.setRowKind(inputRow.getRowKind());
                    return outputRow;
                }
            };
        } else {
            this.rowContainerGenerator = SeaTunnelRowContainerGenerator.REUSE_ROW;
        }
        log.info("Changed input table schema: {} to output table schema: {}", (Object)this.inputCatalogTable.getTableSchema(), (Object)outputTableSchema);
        return outputTableSchema;
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    protected abstract Column getOutputColumn();

    public SingleFieldOutputTransform() {
    }
}

