/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.common.constants.JobMode;

public final class JobContext
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final Map<String, TableSchema> tableSchemaMap = new ConcurrentHashMap<String, TableSchema>(16);
    private JobMode jobMode;
    private final String jobId;

    public JobContext() {
        this.jobId = UUID.randomUUID().toString().replace("-", "");
    }

    public JobContext(Long jobId) {
        this.jobId = jobId + "";
    }

    public void addSchema(String tableName, TableSchema tableSchema) {
        this.tableSchemaMap.put(tableName, tableSchema);
    }

    public Optional<TableSchema> getSchema(String tableName) {
        return Optional.ofNullable(this.tableSchemaMap.get(tableName));
    }

    public JobContext setJobMode(JobMode jobMode) {
        this.jobMode = jobMode;
        return this;
    }

    public JobMode getJobMode() {
        return this.jobMode;
    }

    public String getJobId() {
        return this.jobId;
    }
}

