/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.Collection;

class MultipleRecordStoreForcedEviction
implements ForcedEviction {
    MultipleRecordStoreForcedEviction() {
    }

    @Override
    public boolean forceEvictAndRun(MapOperation mapOperation, double evictionPercentage) {
        assert (evictionPercentage > 0.0 && evictionPercentage <= 1.0);
        int partitionCount = this.numberOfPartitions(mapOperation);
        int threadCount = this.threadCount(mapOperation);
        int mod = this.mod(mapOperation, threadCount);
        ILogger logger = mapOperation.logger();
        int evictionRetryTimes = this.retryCount(evictionPercentage);
        for (int i = 0; i < evictionRetryTimes; ++i) {
            try {
                for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                    if (partitionId % threadCount != mod) continue;
                    Collection recordStores = this.partitionMaps(mapOperation, partitionId).values();
                    for (RecordStore recordStore : recordStores) {
                        int sizeBeforeEviction = recordStore.size();
                        MapContainer mapContainer = recordStore.getMapContainer();
                        Evictor evictor = mapContainer.getEvictor();
                        evictor.forceEvictByPercentage(recordStore, evictionPercentage);
                        if (!logger.isFineEnabled()) continue;
                        MultipleRecordStoreForcedEviction.logForcedEviction(logger, mapOperation, recordStore, evictionPercentage, i + 1, sizeBeforeEviction);
                    }
                }
                mapOperation.runInternal();
                return true;
            }
            catch (NativeOutOfMemoryError e) {
                if (evictionPercentage == 1.0) {
                    throw e;
                }
                EmptyStatement.ignore(e);
                continue;
            }
        }
        return false;
    }

    private static void logForcedEviction(ILogger logger, MapOperation mapOperation, RecordStore recordStore, double evictionPercentage, int attempt, int sizeBeforeEviction) {
        String msg = "Multiple record store forced eviction [attempt: %d, mainMapName: %s, evictingMapName: %s, evictionPercentage: %.2f, partitionId: %d, evictedCount: %d (%d --> %d)]";
        int sizeAfterEviction = recordStore.size();
        logger.fine(String.format(msg, attempt, mapOperation.getName(), recordStore.getName(), evictionPercentage, mapOperation.getPartitionId(), sizeBeforeEviction - sizeAfterEviction, sizeBeforeEviction, sizeAfterEviction));
    }
}

