/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.KafkaKingbaseDataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.datasource.plugin.s3.S3OptionRule;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class S3DataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final Logger log = LoggerFactory.getLogger(S3DataSourceConfigSwitcher.class);

    @Override
    public String getDataSourceName() {
        return "S3";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        excludedKeys.add(S3OptionRule.PATH.key());
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            excludedKeys.add(S3OptionRule.SCHEMA.key());
        }
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            connectorConfig = connectorConfig.withValue(S3OptionRule.SCHEMA.key(), (ConfigValue)KafkaKingbaseDataSourceConfigSwitcher.SchemaGenerator.generateSchemaBySelectTableFields(virtualTableDetail, selectTableFields).root()).withValue(S3OptionRule.PATH.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.PATH.key()))).withValue(S3OptionRule.TYPE.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.TYPE.key()))).withValue(S3OptionRule.PARSE_PARSE_PARTITION_FROM_PATH.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.PARSE_PARSE_PARTITION_FROM_PATH.key()))).withValue(S3OptionRule.DATE_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.DATE_FORMAT.key()))).withValue(S3OptionRule.DATETIME_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.DATETIME_FORMAT.key()))).withValue(S3OptionRule.TIME_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.TIME_FORMAT.key())));
        } else if (PluginType.SINK.equals((Object)pluginType)) {
            if (virtualTableDetail.getDatasourceProperties().get(S3OptionRule.TIME_FORMAT.key()) == null) {
                throw new IllegalArgumentException("S3 virtual table path is null");
            }
            connectorConfig = connectorConfig.withValue(S3OptionRule.PATH.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.PATH.key()))).withValue(S3OptionRule.TYPE.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.TYPE.key()))).withValue(S3OptionRule.PARSE_PARSE_PARTITION_FROM_PATH.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.PARSE_PARSE_PARTITION_FROM_PATH.key()))).withValue(S3OptionRule.DATE_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.DATE_FORMAT.key()))).withValue(S3OptionRule.DATETIME_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.DATETIME_FORMAT.key()))).withValue(S3OptionRule.TIME_FORMAT.key(), ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(S3OptionRule.TIME_FORMAT.key())));
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

