/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.common.ResUploadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();

    private PropertyUtils() {
        throw new UnsupportedOperationException("Construct PropertyUtils");
    }

    public static synchronized void loadPropertyFile(String ... propertyFiles) {
        for (String fileName : propertyFiles) {
            try (InputStream fis = PropertyUtils.class.getResourceAsStream(fileName);){
                properties.load(fis);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> logger.info("Get property from {}: {} -> {}", new Object[]{fileName, k, v})));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = String.valueOf(k);
            logger.info("Overriding property from system property: {}", (Object)key);
            PropertyUtils.setValue(key, String.valueOf(v));
        }));
        for (Map.Entry entry : properties.entrySet()) {
            Object key = entry.getKey();
            String envVarKey = String.valueOf(key).replaceAll("[.-]", "_").toUpperCase();
            String envVarVal = System.getenv(envVarKey);
            if (!Objects.nonNull(envVarVal)) continue;
            logger.info("Overriding property {} with system environment variable {}", key, (Object)envVarKey);
            entry.setValue(envVarVal);
        }
    }

    public static boolean getResUploadStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString("resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf(StringUtils.isEmpty((CharSequence)resUploadStartupType) ? ResUploadType.NONE.name() : resUploadStartupType);
        return resUploadType != ResUploadType.NONE;
    }

    public static String getString(String key) {
        return properties.getProperty(key.trim());
    }

    public static String getUpperCaseString(String key) {
        String val = PropertyUtils.getString(key);
        return StringUtils.isEmpty((CharSequence)val) ? val : val.toUpperCase();
    }

    public static String getString(String key, String defaultVal) {
        String val = PropertyUtils.getString(key);
        return StringUtils.isEmpty((CharSequence)val) ? defaultVal : val;
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key) {
        return PropertyUtils.getBoolean(key, false);
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = PropertyUtils.getString(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public static long getLong(String key, long defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static long getLong(String key) {
        return PropertyUtils.getLong(key, -1L);
    }

    public static double getDouble(String key, double defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static String[] getArray(String key, String splitStr) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new String[0];
        }
        return value.split(splitStr);
    }

    public static <T> List<T> getList(String key, String splitStr, Function<String, T> elementTransform) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(splitStr)).map(elementTransform).collect(Collectors.toList());
    }

    public static List<String> getList(String key, String splitStr) {
        return PropertyUtils.getList(key, splitStr, Function.identity());
    }

    public static <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, value);
        }
        catch (IllegalArgumentException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static Map<String, String> getPrefixedProperties(String prefix) {
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith(prefix)) continue;
            matchedProperties.put(propName, properties.getProperty(propName));
        }
        return matchedProperties;
    }

    public static void setValue(String key, String value) {
        properties.setProperty(key, value);
    }

    public static Map<String, String> getPropertiesByPrefix(String prefix) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return null;
        }
        Set<Object> keys = properties.keySet();
        if (keys.isEmpty()) {
            return null;
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        keys.forEach(k -> {
            if (k.toString().contains(prefix)) {
                propertiesMap.put(k.toString().replaceFirst(prefix + ".", ""), properties.getProperty((String)k));
            }
        });
        return propertiesMap;
    }

    static {
        PropertyUtils.loadPropertyFile("/common.properties");
    }
}

