/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.typesafe.config.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigException;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigMergeable;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigObject;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigOrigin;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.impl.AbstractConfigObject;
import org.apache.seatunnel.shade.com.typesafe.config.impl.AbstractConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.impl.Container;
import org.apache.seatunnel.shade.com.typesafe.config.impl.Path;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ResolveContext;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ResolveResult;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ResolveSource;
import org.apache.seatunnel.shade.com.typesafe.config.impl.ResolveStatus;
import org.apache.seatunnel.shade.com.typesafe.config.impl.SerializedConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.impl.SimpleConfig;
import org.apache.seatunnel.shade.com.typesafe.config.impl.SimpleConfigOrigin;

final class SimpleConfigObject
extends AbstractConfigObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Map<String, AbstractConfigValue> value;
    private final boolean resolved;
    private final boolean ignoresFallbacks;
    private static final SimpleConfigObject EMPTY_INSTANCE = SimpleConfigObject.empty((ConfigOrigin)SimpleConfigOrigin.newSimple((String)"empty config"));
    private static final int HASH_CODE = 41;

    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value, ResolveStatus status, boolean ignoresFallbacks) {
        super(origin);
        if (value == null) {
            throw new ConfigException.BugOrBroken("creating config object with null map");
        }
        this.value = value;
        this.resolved = status == ResolveStatus.RESOLVED;
        this.ignoresFallbacks = ignoresFallbacks;
        if (status != ResolveStatus.fromValues(value.values())) {
            throw new ConfigException.BugOrBroken("Wrong resolved status on " + this);
        }
    }

    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value) {
        this(origin, value, ResolveStatus.fromValues(value.values()), false);
    }

    public SimpleConfigObject withOnlyKey(String key) {
        return this.withOnlyPath(Path.newKey(key));
    }

    public SimpleConfigObject withoutKey(String key) {
        return this.withoutPath(Path.newKey(key));
    }

    protected SimpleConfigObject withOnlyPathOrNull(Path path) {
        String key = path.first();
        Path next = path.remainder();
        Object v = this.value.get(key);
        if (next != null) {
            v = v instanceof AbstractConfigObject ? ((AbstractConfigObject)v).withOnlyPathOrNull(next) : null;
        }
        return v == null ? null : new SimpleConfigObject((ConfigOrigin)this.origin(), Collections.singletonMap(key, v), v.resolveStatus(), this.ignoresFallbacks);
    }

    SimpleConfigObject withOnlyPath(Path path) {
        SimpleConfigObject o = this.withOnlyPathOrNull(path);
        return o == null ? new SimpleConfigObject((ConfigOrigin)this.origin(), Collections.emptyMap(), ResolveStatus.RESOLVED, this.ignoresFallbacks) : o;
    }

    SimpleConfigObject withoutPath(Path path) {
        String key = path.first();
        Path next = path.remainder();
        AbstractConfigValue v = this.value.get(key);
        if (next != null && v instanceof AbstractConfigObject) {
            v = ((AbstractConfigObject)v).withoutPath(next);
            LinkedHashMap<String, AbstractConfigValue> smaller = new LinkedHashMap<String, AbstractConfigValue>(this.value);
            smaller.put(key, v);
            return new SimpleConfigObject((ConfigOrigin)this.origin(), smaller, ResolveStatus.fromValues(((HashMap)smaller).values()), this.ignoresFallbacks);
        }
        if (next == null && v != null) {
            LinkedHashMap<String, AbstractConfigValue> smaller = new LinkedHashMap<String, AbstractConfigValue>(this.value.size() - 1);
            for (Map.Entry<String, AbstractConfigValue> stringAbstractConfigValueEntry : this.value.entrySet()) {
                if (stringAbstractConfigValueEntry.getKey().equals(key)) continue;
                smaller.put(stringAbstractConfigValueEntry.getKey(), stringAbstractConfigValueEntry.getValue());
            }
            return new SimpleConfigObject((ConfigOrigin)this.origin(), smaller, ResolveStatus.fromValues(((HashMap)smaller).values()), this.ignoresFallbacks);
        }
        return this;
    }

    public SimpleConfigObject withValue(String key, ConfigValue v) {
        Map<String, AbstractConfigValue> newMap;
        if (v == null) {
            throw new ConfigException.BugOrBroken("Trying to store null ConfigValue in a ConfigObject");
        }
        if (this.value.isEmpty()) {
            newMap = Collections.singletonMap(key, (AbstractConfigValue)v);
        } else {
            newMap = new LinkedHashMap<String, AbstractConfigValue>(this.value);
            newMap.put(key, (AbstractConfigValue)v);
        }
        return new SimpleConfigObject((ConfigOrigin)this.origin(), newMap, ResolveStatus.fromValues(newMap.values()), this.ignoresFallbacks);
    }

    SimpleConfigObject withValue(Path path, ConfigValue v) {
        String key = path.first();
        Path next = path.remainder();
        if (next == null) {
            return this.withValue(key, v);
        }
        AbstractConfigValue child = this.value.get(key);
        if (child instanceof AbstractConfigObject) {
            return this.withValue(key, (ConfigValue)((AbstractConfigObject)child).withValue(next, v));
        }
        SimpleConfig subtree = ((AbstractConfigValue)v).atPath((ConfigOrigin)SimpleConfigOrigin.newSimple((String)("withValue(" + next.render() + ")")), next);
        return this.withValue(key, (ConfigValue)subtree.root());
    }

    protected AbstractConfigValue attemptPeekWithPartialResolve(String key) {
        return this.value.get(key);
    }

    private SimpleConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin, boolean newIgnoresFallbacks) {
        return new SimpleConfigObject(newOrigin, this.value, newStatus, newIgnoresFallbacks);
    }

    protected SimpleConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin) {
        return this.newCopy(newStatus, newOrigin, this.ignoresFallbacks);
    }

    protected SimpleConfigObject withFallbacksIgnored() {
        return this.ignoresFallbacks ? this : this.newCopy(this.resolveStatus(), (ConfigOrigin)this.origin(), true);
    }

    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean((boolean)this.resolved);
    }

    public SimpleConfigObject replaceChild(AbstractConfigValue child, AbstractConfigValue replacement) {
        Map.Entry old;
        LinkedHashMap<String, AbstractConfigValue> newChildren = new LinkedHashMap<String, AbstractConfigValue>(this.value);
        Iterator var4 = newChildren.entrySet().iterator();
        do {
            if (var4.hasNext()) continue;
            throw new ConfigException.BugOrBroken("SimpleConfigObject.replaceChild did not find " + child + " in " + this);
        } while ((old = var4.next()).getValue() != child);
        if (replacement != null) {
            old.setValue(replacement);
        } else {
            newChildren.remove(old.getKey());
        }
        return new SimpleConfigObject((ConfigOrigin)this.origin(), newChildren, ResolveStatus.fromValues(newChildren.values()), this.ignoresFallbacks);
    }

    public boolean hasDescendant(AbstractConfigValue descendant) {
        AbstractConfigValue child;
        Iterator<AbstractConfigValue> var2 = this.value.values().iterator();
        do {
            if (var2.hasNext()) continue;
            var2 = this.value.values().iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while (!((child = var2.next()) instanceof Container) || !((Container)child).hasDescendant(descendant));
            return true;
        } while ((child = var2.next()) != descendant);
        return true;
    }

    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    public Map<String, Object> unwrapped() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, AbstractConfigValue> stringAbstractConfigValueEntry : this.value.entrySet()) {
            m.put(stringAbstractConfigValueEntry.getKey(), stringAbstractConfigValueEntry.getValue().unwrapped());
        }
        return m;
    }

    protected SimpleConfigObject mergedWithObject(AbstractConfigObject abstractFallback) {
        this.requireNotIgnoringFallbacks();
        if (!(abstractFallback instanceof SimpleConfigObject)) {
            throw new ConfigException.BugOrBroken("should not be reached (merging non-SimpleConfigObject)");
        }
        SimpleConfigObject fallback = (SimpleConfigObject)abstractFallback;
        boolean changed = false;
        boolean allResolved = true;
        LinkedHashMap<String, AbstractConfigValue> merged = new LinkedHashMap<String, AbstractConfigValue>();
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.keySet());
        allKeys.addAll(fallback.keySet());
        for (String key : allKeys) {
            AbstractConfigValue first = this.value.get(key);
            AbstractConfigValue second = fallback.value.get(key);
            AbstractConfigValue kept = first == null ? second : (second == null ? first : first.withFallback((ConfigMergeable)second));
            merged.put(key, kept);
            if (first != kept) {
                changed = true;
            }
            if (kept.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            allResolved = false;
        }
        ResolveStatus newResolveStatus = ResolveStatus.fromBoolean((boolean)allResolved);
        boolean newIgnoresFallbacks = fallback.ignoresFallbacks();
        if (changed) {
            return new SimpleConfigObject(SimpleConfigObject.mergeOrigins((AbstractConfigObject[])new AbstractConfigObject[]{this, fallback}), merged, newResolveStatus, newIgnoresFallbacks);
        }
        if (newResolveStatus == this.resolveStatus() && newIgnoresFallbacks == this.ignoresFallbacks()) {
            return this;
        }
        return this.newCopy(newResolveStatus, (ConfigOrigin)this.origin(), newIgnoresFallbacks);
    }

    private SimpleConfigObject modify(AbstractConfigValue.NoExceptionsModifier modifier) {
        try {
            return this.modifyMayThrow((AbstractConfigValue.Modifier)modifier);
        }
        catch (RuntimeException var3) {
            throw var3;
        }
        catch (Exception var4) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var4);
        }
    }

    private SimpleConfigObject modifyMayThrow(AbstractConfigValue.Modifier modifier) throws Exception {
        LinkedHashMap<String, AbstractConfigValue> changes = null;
        for (String k : this.keySet()) {
            AbstractConfigValue v;
            AbstractConfigValue modified = modifier.modifyChildMayThrow(k, v = this.value.get(k));
            if (modified == v) continue;
            if (changes == null) {
                changes = new LinkedHashMap<String, AbstractConfigValue>();
            }
            changes.put(k, modified);
        }
        if (changes == null) {
            return this;
        }
        LinkedHashMap<String, AbstractConfigValue> modified = new LinkedHashMap<String, AbstractConfigValue>();
        boolean sawUnresolved = false;
        for (String k : this.keySet()) {
            AbstractConfigValue newValue;
            if (changes.containsKey(k)) {
                newValue = (AbstractConfigValue)changes.get(k);
                if (newValue == null) continue;
                modified.put(k, newValue);
                if (newValue.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
                sawUnresolved = true;
                continue;
            }
            newValue = this.value.get(k);
            modified.put(k, newValue);
            if (newValue.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            sawUnresolved = true;
        }
        return new SimpleConfigObject((ConfigOrigin)this.origin(), modified, sawUnresolved ? ResolveStatus.UNRESOLVED : ResolveStatus.RESOLVED, this.ignoresFallbacks());
    }

    ResolveResult<? extends AbstractConfigObject> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return ResolveResult.make((ResolveContext)context, (AbstractConfigValue)this);
        }
        ResolveSource sourceWithParent = source.pushParent((Container)this);
        try {
            ResolveModifier modifier = new ResolveModifier(context, sourceWithParent);
            SimpleConfigObject value = this.modifyMayThrow(modifier);
            return ResolveResult.make((ResolveContext)modifier.context, (AbstractConfigValue)value).asObjectResult();
        }
        catch (RuntimeException | AbstractConfigValue.NotPossibleToResolve var6) {
            throw var6;
        }
        catch (Exception var8) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", (Throwable)var8);
        }
    }

    SimpleConfigObject relativized(final Path prefix) {
        return this.modify(new AbstractConfigValue.NoExceptionsModifier(){

            public AbstractConfigValue modifyChild(String key, AbstractConfigValue v) {
                return v.relativized(prefix);
            }
        });
    }

    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        if (this.isEmpty()) {
            sb.append("{}");
        } else {
            String[] keys;
            int innerIndent;
            boolean outerBraces;
            boolean bl = outerBraces = options.getJson() || !atRoot;
            if (outerBraces) {
                innerIndent = indent + 1;
                sb.append("{");
                if (options.getFormatted()) {
                    sb.append('\n');
                }
            } else {
                innerIndent = indent;
            }
            int separatorCount = 0;
            for (String k : keys = this.keySet().toArray(new String[0])) {
                AbstractConfigValue v = this.value.get(k);
                if (options.getOriginComments()) {
                    String[] lines;
                    for (String l : lines = v.origin().description().split("\n")) {
                        SimpleConfigObject.indent((StringBuilder)sb, (int)(indent + 1), (ConfigRenderOptions)options);
                        sb.append('#');
                        if (!l.isEmpty()) {
                            sb.append(' ');
                        }
                        sb.append(l);
                        sb.append("\n");
                    }
                }
                if (options.getComments()) {
                    for (String comment : v.origin().comments()) {
                        SimpleConfigObject.indent((StringBuilder)sb, (int)innerIndent, (ConfigRenderOptions)options);
                        sb.append("#");
                        if (!comment.startsWith(" ")) {
                            sb.append(' ');
                        }
                        sb.append(comment);
                        sb.append("\n");
                    }
                }
                SimpleConfigObject.indent((StringBuilder)sb, (int)innerIndent, (ConfigRenderOptions)options);
                v.render(sb, innerIndent, false, k, options);
                if (options.getFormatted()) {
                    if (options.getJson()) {
                        sb.append(",");
                        separatorCount = 2;
                    } else {
                        separatorCount = 1;
                    }
                    sb.append('\n');
                    continue;
                }
                sb.append(",");
                separatorCount = 1;
            }
            sb.setLength(sb.length() - separatorCount);
            if (outerBraces) {
                if (options.getFormatted()) {
                    sb.append('\n');
                    SimpleConfigObject.indent((StringBuilder)sb, (int)indent, (ConfigRenderOptions)options);
                }
                sb.append("}");
            }
        }
        if (atRoot && options.getFormatted()) {
            sb.append('\n');
        }
    }

    public AbstractConfigValue get(Object key) {
        return this.value.get(key);
    }

    private static boolean mapEquals(Map<String, ConfigValue> a, Map<String, ConfigValue> b) {
        Set<String> bKeys;
        if (a == b) {
            return true;
        }
        Set<String> aKeys = a.keySet();
        if (aKeys.equals(bKeys = b.keySet())) {
            String key;
            Iterator<String> var4 = aKeys.iterator();
            do {
                if (var4.hasNext()) continue;
                return true;
            } while (a.get(key = var4.next()).equals(b.get(key)));
        }
        return false;
    }

    private static int mapHash(Map<String, ConfigValue> m) {
        ArrayList<String> keys = new ArrayList<String>(m.keySet());
        Collections.sort(keys);
        int valuesHash = 0;
        for (String k : keys) {
            valuesHash += m.get(k).hashCode();
        }
        return 41 * (41 + keys.hashCode()) + valuesHash;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigObject;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConfigObject)) {
            return false;
        }
        return this.canEqual(other) && SimpleConfigObject.mapEquals((Map<String, ConfigValue>)((Object)this), (Map<String, ConfigValue>)((ConfigObject)other));
    }

    public int hashCode() {
        return SimpleConfigObject.mapHash((Map<String, ConfigValue>)((Object)this));
    }

    public boolean containsKey(Object key) {
        return this.value.containsKey(key);
    }

    public Set<String> keySet() {
        return this.value.keySet();
    }

    public boolean containsValue(Object v) {
        return this.value.containsValue(v);
    }

    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        HashSet<Map.Entry<String, ConfigValue>> entries = new HashSet<Map.Entry<String, ConfigValue>>();
        for (Map.Entry<String, AbstractConfigValue> stringAbstractConfigValueEntry : this.value.entrySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<String, AbstractConfigValue>(stringAbstractConfigValueEntry.getKey(), stringAbstractConfigValueEntry.getValue()));
        }
        return entries;
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public int size() {
        return this.value.size();
    }

    public Collection<ConfigValue> values() {
        return new HashSet<AbstractConfigValue>(this.value.values());
    }

    static SimpleConfigObject empty() {
        return EMPTY_INSTANCE;
    }

    static SimpleConfigObject empty(ConfigOrigin origin) {
        return origin == null ? SimpleConfigObject.empty() : new SimpleConfigObject(origin, Collections.emptyMap());
    }

    static SimpleConfigObject emptyMissing(ConfigOrigin baseOrigin) {
        return new SimpleConfigObject((ConfigOrigin)SimpleConfigOrigin.newSimple((String)(baseOrigin.description() + " (not found)")), Collections.emptyMap());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue((ConfigValue)this);
    }

    private static final class ResolveModifier
    implements AbstractConfigValue.Modifier {
        final Path originalRestrict;
        ResolveContext context;
        final ResolveSource source;

        ResolveModifier(ResolveContext context, ResolveSource source) {
            this.context = context;
            this.source = source;
            this.originalRestrict = context.restrictToChild();
        }

        public AbstractConfigValue modifyChildMayThrow(String key, AbstractConfigValue v) throws AbstractConfigValue.NotPossibleToResolve {
            if (this.context.isRestrictedToChild()) {
                if (key.equals(this.context.restrictToChild().first())) {
                    Path remainder = this.context.restrictToChild().remainder();
                    if (remainder != null) {
                        ResolveResult result = this.context.restrict(remainder).resolve(v, this.source);
                        this.context = result.context.unrestricted().restrict(this.originalRestrict);
                        return result.value;
                    }
                    return v;
                }
                return v;
            }
            ResolveResult result = this.context.unrestricted().resolve(v, this.source);
            this.context = result.context.unrestricted().restrict(this.originalRestrict);
            return result.value;
        }
    }
}

