/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRddTool;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.sedona.core.enums.IndexType;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;

public final class IndexBuilder<T extends Geometry>
implements FlatMapFunction<Iterator<T>, SpatialIndex> {
    IndexType indexType;

    public IndexBuilder(IndexType indexType) {
        this.indexType = indexType;
    }

    public Iterator<SpatialIndex> call(Iterator<T> objectIterator) throws Exception {
        Object spatialIndex = this.indexType == IndexType.RTREE ? new STRtree() : new Quadtree();
        while (objectIterator.hasNext()) {
            Geometry spatialObject = (Geometry)objectIterator.next();
            spatialIndex.insert(spatialObject.getEnvelopeInternal(), (Object)spatialObject);
        }
        HashSet<STRtree> result2 = new HashSet<STRtree>();
        spatialIndex.query(new Envelope(0.0, 0.0, 0.0, 0.0));
        result2.add((STRtree)spatialIndex);
        return result2.iterator();
    }
}

