/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class Functions {

    public static class ST_LineFromMultiPoint
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.lineFromMultiPoint((Geometry)geom);
        }
    }

    public static class ST_SetPoint
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, int position, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry linestring = (Geometry)o1;
            Geometry point = (Geometry)o2;
            return org.apache.sedona.common.Functions.setPoint((Geometry)linestring, (int)position, (Geometry)point);
        }
    }

    public static class ST_RemovePoint
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.removePoint((Geometry)geom);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int offset) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.removePoint((Geometry)geom, (int)offset);
        }
    }

    public static class ST_AddPoint
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry linestring = (Geometry)o1;
            Geometry point = (Geometry)o2;
            return org.apache.sedona.common.Functions.addPoint((Geometry)linestring, (Geometry)point);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2, int position) {
            Geometry linestring = (Geometry)o1;
            Geometry point = (Geometry)o2;
            return org.apache.sedona.common.Functions.addPoint((Geometry)linestring, (Geometry)point, (int)position);
        }
    }

    public static class ST_Normalize
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.normalize((Geometry)geom);
        }
    }

    public static class ST_IsValid
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.isValid((Geometry)geom);
        }
    }

    public static class ST_IsSimple
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.isSimple((Geometry)geom);
        }
    }

    public static class ST_IsRing
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.isRing((Geometry)geom);
        }
    }

    public static class ST_IsClosed
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.isClosed((Geometry)geom);
        }
    }

    public static class ST_SRID
    extends ScalarFunction {
        @DataTypeHint(value="Integer")
        public Integer eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.getSRID((Geometry)geom);
        }
    }

    public static class ST_SetSRID
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int srid) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.setSRID((Geometry)geom, (int)srid);
        }
    }

    public static class ST_BuildArea
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.buildArea((Geometry)geom);
        }
    }

    public static class ST_XMin
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.xMin((Geometry)geom);
        }
    }

    public static class ST_XMax
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.xMax((Geometry)geom);
        }
    }

    public static class ST_Z
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.z((Geometry)geom);
        }
    }

    public static class ST_Y
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.y((Geometry)geom);
        }
    }

    public static class ST_X
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.x((Geometry)geom);
        }
    }

    public static class ST_IsEmpty
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.isEmpty((Geometry)geom);
        }
    }

    public static class ST_Force_2D
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.force2D((Geometry)geom);
        }
    }

    public static class ST_AsKML
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asKML((Geometry)geom);
        }
    }

    public static class ST_AsGML
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asGML((Geometry)geom);
        }
    }

    public static class ST_AsGeoJSON
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asGeoJson((Geometry)geom);
        }
    }

    public static class ST_AsBinary
    extends ScalarFunction {
        @DataTypeHint(value="Bytes")
        public byte[] eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asEWKB((Geometry)geom);
        }
    }

    public static class ST_AsEWKB
    extends ScalarFunction {
        @DataTypeHint(value="Bytes")
        public byte[] eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asEWKB((Geometry)geom);
        }
    }

    public static class ST_AsText
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asEWKT((Geometry)geom);
        }
    }

    public static class ST_AsEWKT
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.asEWKT((Geometry)geom);
        }
    }

    public static class ST_ExteriorRing
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.exteriorRing((Geometry)geom);
        }
    }

    public static class ST_NumInteriorRings
    extends ScalarFunction {
        @DataTypeHint(value="Integer")
        public Integer eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.numInteriorRings((Geometry)geom);
        }
    }

    public static class ST_NumGeometries
    extends ScalarFunction {
        @DataTypeHint(value="Integer")
        public Integer eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.numGeometries((Geometry)geom);
        }
    }

    public static class ST_NPoints
    extends ScalarFunction {
        @DataTypeHint(value="Integer")
        public Integer eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.nPoints((Geometry)geom);
        }
    }

    public static class ST_PointN
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int n) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.pointN((Geometry)geom, (int)n);
        }
    }

    public static class ST_InteriorRingN
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int n) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.interiorRingN((Geometry)geom, (int)n);
        }
    }

    public static class ST_GeometryN
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int n) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.geometryN((Geometry)geom, (int)n);
        }
    }

    public static class ST_Reverse
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.reverse((Geometry)geom);
        }
    }

    public static class ST_PointOnSurface
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.pointOnSurface((Geometry)geom);
        }
    }

    public static class ST_GeoHash
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object geometry, Integer precision) {
            Geometry geom = (Geometry)geometry;
            return org.apache.sedona.common.Functions.geohash((Geometry)geom, (int)precision);
        }
    }

    public static class ST_FlipCoordinates
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.flipCoordinates((Geometry)geom);
        }
    }

    public static class ST_Transform
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, @DataTypeHint(value="String") String sourceCRS, @DataTypeHint(value="String") String targetCRS) throws FactoryException, TransformException {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.transform((Geometry)geom, (String)sourceCRS, (String)targetCRS);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, @DataTypeHint(value="String") String sourceCRS, @DataTypeHint(value="String") String targetCRS, @DataTypeHint(value="Boolean") Boolean lenient) throws FactoryException, TransformException {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.transform((Geometry)geom, (String)sourceCRS, (String)targetCRS, (boolean)lenient);
        }
    }

    public static class ST_YMax
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.yMax((Geometry)geom);
        }
    }

    public static class ST_YMin
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.yMin((Geometry)geom);
        }
    }

    public static class ST_Length
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.length((Geometry)geom);
        }
    }

    public static class ST_3DDistance
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return org.apache.sedona.common.Functions.distance3d((Geometry)geom1, (Geometry)geom2);
        }
    }

    public static class ST_Distance
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return org.apache.sedona.common.Functions.distance((Geometry)geom1, (Geometry)geom2);
        }
    }

    public static class ST_Envelope
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.envelope((Geometry)geom);
        }
    }

    public static class ST_Buffer
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, @DataTypeHint(value="Double") Double radius) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.buffer((Geometry)geom, (double)radius);
        }
    }

    public static class ST_Boundary
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.boundary((Geometry)geom);
        }
    }

    public static class ST_Azimuth
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return org.apache.sedona.common.Functions.azimuth((Geometry)geom1, (Geometry)geom2);
        }
    }

    public static class ST_Area
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return org.apache.sedona.common.Functions.area((Geometry)geom);
        }
    }
}

