/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRDD;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.log4j.Logger;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.spatialPartitioning.FlatGridPartitioner;
import org.apache.sedona.core.spatialPartitioning.KDB;
import org.apache.sedona.core.spatialPartitioning.KDBTreePartitioner;
import org.apache.sedona.core.spatialPartitioning.QuadTreePartitioner;
import org.apache.sedona.core.spatialPartitioning.QuadtreePartitioning;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.sedona.core.spatialPartitioning.quadtree.StandardQuadTree;
import org.apache.sedona.core.spatialRDD.RectangleRDD;
import org.apache.sedona.core.spatialRddTool.IndexBuilder;
import org.apache.sedona.core.spatialRddTool.StatCalculator;
import org.apache.sedona.core.utils.RDDSampleUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.random.SamplingUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.wololo.geojson.Feature;
import org.wololo.jts2geojson.GeoJSONWriter;
import scala.Tuple2;

public class SpatialRDD<T extends Geometry>
implements Serializable {
    static final Logger logger = Logger.getLogger(SpatialRDD.class);
    public long approximateTotalCount = -1L;
    public Envelope boundaryEnvelope = null;
    public JavaRDD<T> spatialPartitionedRDD;
    public JavaRDD<SpatialIndex> indexedRDD;
    public JavaRDD<SpatialIndex> indexedRawRDD;
    public JavaRDD<T> rawSpatialRDD;
    public List<String> fieldNames;
    protected boolean CRStransformation = false;
    protected String sourceEpsgCode = "";
    protected String targetEpgsgCode = "";
    private SpatialPartitioner partitioner;
    private int sampleNumber = -1;

    public int getSampleNumber() {
        return this.sampleNumber;
    }

    public void setSampleNumber(int sampleNumber) {
        this.sampleNumber = sampleNumber;
    }

    public boolean CRSTransform(String sourceEpsgCRSCode, String targetEpsgCRSCode, boolean lenient) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetEpsgCRSCode);
            final MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
            this.CRStransformation = true;
            this.sourceEpsgCode = sourceEpsgCRSCode;
            this.targetEpgsgCode = targetEpsgCRSCode;
            this.rawSpatialRDD = this.rawSpatialRDD.map(new Function<T, T>(){

                public T call(T originalObject) throws Exception {
                    return JTS.transform(originalObject, (MathTransform)transform);
                }
            });
            return true;
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean CRSTransform(String sourceEpsgCRSCode, String targetEpsgCRSCode) {
        return this.CRSTransform(sourceEpsgCRSCode, targetEpsgCRSCode, false);
    }

    public boolean spatialPartitioning(GridType gridType) throws Exception {
        int numPartitions = this.rawSpatialRDD.rdd().partitions().length;
        this.spatialPartitioning(gridType, numPartitions);
        return true;
    }

    public void calc_partitioner(GridType gridType, int numPartitions) throws Exception {
        if (numPartitions <= 0) {
            throw new IllegalArgumentException("Number of partitions must be >= 0");
        }
        if (this.boundaryEnvelope == null) {
            throw new Exception("[AbstractSpatialRDD][spatialPartitioning] SpatialRDD boundary is null. Please call analyze() first.");
        }
        if (this.approximateTotalCount == -1L) {
            throw new Exception("[AbstractSpatialRDD][spatialPartitioning] SpatialRDD total count is unkown. Please call analyze() first.");
        }
        int sampleNumberOfRecords = RDDSampleUtils.getSampleNumbers(numPartitions, this.approximateTotalCount, this.sampleNumber);
        double fraction = SamplingUtils.computeFractionForSampleSize((int)sampleNumberOfRecords, (long)this.approximateTotalCount, (boolean)false);
        List samples = this.rawSpatialRDD.sample(false, fraction).map(new Function<T, Envelope>(){

            public Envelope call(T geometry) throws Exception {
                return geometry.getEnvelopeInternal();
            }
        }).collect();
        logger.info((Object)("Collected " + samples.size() + " samples"));
        Envelope paddedBoundary = new Envelope(this.boundaryEnvelope.getMinX(), this.boundaryEnvelope.getMaxX() + 0.01, this.boundaryEnvelope.getMinY(), this.boundaryEnvelope.getMaxY() + 0.01);
        switch (gridType) {
            case EQUALGRID: {
                int minLevel = (int)Math.max(Math.log(numPartitions) / Math.log(4.0), 0.0);
                QuadtreePartitioning quadtreePartitioning = new QuadtreePartitioning(new ArrayList<Envelope>(), paddedBoundary, numPartitions, minLevel);
                StandardQuadTree tree = quadtreePartitioning.getPartitionTree();
                this.partitioner = new QuadTreePartitioner(tree);
                break;
            }
            case QUADTREE: {
                QuadtreePartitioning quadtreePartitioning = new QuadtreePartitioning(samples, paddedBoundary, numPartitions);
                StandardQuadTree tree = quadtreePartitioning.getPartitionTree();
                this.partitioner = new QuadTreePartitioner(tree);
                break;
            }
            case KDBTREE: {
                KDB tree = new KDB(samples.size() / numPartitions, numPartitions, paddedBoundary);
                for (Envelope sample : samples) {
                    tree.insert(sample);
                }
                tree.assignLeafIds();
                this.partitioner = new KDBTreePartitioner(tree);
                break;
            }
            default: {
                throw new Exception("[AbstractSpatialRDD][spatialPartitioning] Unsupported spatial partitioning method. The following partitioning methods are not longer supported: R-Tree, Hilbert curve, Voronoi");
            }
        }
    }

    public void spatialPartitioning(GridType gridType, int numPartitions) throws Exception {
        this.calc_partitioner(gridType, numPartitions);
        this.spatialPartitionedRDD = this.partition(this.partitioner);
    }

    public SpatialPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void spatialPartitioning(SpatialPartitioner partitioner) {
        this.partitioner = partitioner;
        this.spatialPartitionedRDD = this.partition(partitioner);
    }

    public boolean spatialPartitioning(List<Envelope> otherGrids) throws Exception {
        this.partitioner = new FlatGridPartitioner(otherGrids);
        this.spatialPartitionedRDD = this.partition(this.partitioner);
        return true;
    }

    public boolean spatialPartitioning(StandardQuadTree partitionTree) throws Exception {
        this.partitioner = new QuadTreePartitioner(partitionTree);
        this.spatialPartitionedRDD = this.partition(this.partitioner);
        return true;
    }

    private JavaRDD<T> partition(final SpatialPartitioner partitioner) {
        return this.rawSpatialRDD.flatMapToPair(new PairFlatMapFunction<T, Integer, T>(){

            public Iterator<Tuple2<Integer, T>> call(T spatialObject) throws Exception {
                return partitioner.placeObject(spatialObject);
            }
        }).partitionBy((Partitioner)partitioner).mapPartitions(new FlatMapFunction<Iterator<Tuple2<Integer, T>>, T>(){

            public Iterator<T> call(final Iterator<Tuple2<Integer, T>> tuple2Iterator) throws Exception {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return tuple2Iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return (Geometry)((Tuple2)tuple2Iterator.next())._2();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, true);
    }

    public long countWithoutDuplicates() {
        List collectedResult = this.rawSpatialRDD.collect();
        HashSet resultWithoutDuplicates = new HashSet();
        for (int i = 0; i < collectedResult.size(); ++i) {
            resultWithoutDuplicates.add(collectedResult.get(i));
        }
        return resultWithoutDuplicates.size();
    }

    public long countWithoutDuplicatesSPRDD() {
        JavaRDD<T> cleanedRDD = this.spatialPartitionedRDD;
        List collectedResult = cleanedRDD.collect();
        HashSet resultWithoutDuplicates = new HashSet();
        for (int i = 0; i < collectedResult.size(); ++i) {
            resultWithoutDuplicates.add(collectedResult.get(i));
        }
        return resultWithoutDuplicates.size();
    }

    public void buildIndex(IndexType indexType, boolean buildIndexOnSpatialPartitionedRDD) throws Exception {
        if (!buildIndexOnSpatialPartitionedRDD) {
            this.indexedRawRDD = this.rawSpatialRDD.mapPartitions(new IndexBuilder(indexType));
        } else {
            if (this.spatialPartitionedRDD == null) {
                throw new Exception("[AbstractSpatialRDD][buildIndex] spatialPartitionedRDD is null. Please do spatial partitioning before build index.");
            }
            this.indexedRDD = this.spatialPartitionedRDD.mapPartitions(new IndexBuilder(indexType));
        }
    }

    public Envelope boundary() {
        this.analyze();
        return this.boundaryEnvelope;
    }

    public JavaRDD<T> getRawSpatialRDD() {
        return this.rawSpatialRDD;
    }

    public void setRawSpatialRDD(JavaRDD<T> rawSpatialRDD) {
        this.rawSpatialRDD = rawSpatialRDD;
    }

    public boolean analyze(StorageLevel newLevel) {
        this.rawSpatialRDD = this.rawSpatialRDD.persist(newLevel);
        this.analyze();
        return true;
    }

    public boolean analyze() {
        Function2<StatCalculator, Geometry, StatCalculator> seqOp = new Function2<StatCalculator, Geometry, StatCalculator>(){

            public StatCalculator call(StatCalculator agg, Geometry object) throws Exception {
                return StatCalculator.add(agg, object);
            }
        };
        Function2<StatCalculator, StatCalculator, StatCalculator> combOp = new Function2<StatCalculator, StatCalculator, StatCalculator>(){

            public StatCalculator call(StatCalculator agg1, StatCalculator agg2) throws Exception {
                return StatCalculator.combine(agg1, agg2);
            }
        };
        StatCalculator agg = (StatCalculator)this.rawSpatialRDD.aggregate(null, (Function2)seqOp, (Function2)combOp);
        if (agg != null) {
            this.boundaryEnvelope = agg.getBoundary();
            this.approximateTotalCount = agg.getCount();
        } else {
            this.boundaryEnvelope = null;
            this.approximateTotalCount = 0L;
        }
        return true;
    }

    public boolean analyze(Envelope datasetBoundary, Integer approximateTotalCount) {
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
        return true;
    }

    public void saveAsWKB(String outputLocation) {
        if (this.rawSpatialRDD == null) {
            throw new NullArgumentException("save as WKB cannot operate on null RDD");
        }
        this.rawSpatialRDD.mapPartitions(new FlatMapFunction<Iterator<T>, String>(){

            public Iterator<String> call(Iterator<T> iterator) throws Exception {
                WKBWriter writer = new WKBWriter(3, true);
                ArrayList<String> wkbs = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Geometry spatialObject = (Geometry)iterator.next();
                    String wkb = WKBWriter.toHex((byte[])writer.write(spatialObject));
                    if (spatialObject.getUserData() != null) {
                        wkbs.add(wkb + "\t" + spatialObject.getUserData());
                        continue;
                    }
                    wkbs.add(wkb);
                }
                return wkbs.iterator();
            }
        }).saveAsTextFile(outputLocation);
    }

    public void saveAsWKT(String outputLocation) {
        if (this.rawSpatialRDD == null) {
            throw new NullArgumentException("save as WKT cannot operate on null RDD");
        }
        this.rawSpatialRDD.mapPartitions(new FlatMapFunction<Iterator<T>, String>(){

            public Iterator<String> call(Iterator<T> iterator) throws Exception {
                WKTWriter writer = new WKTWriter(3);
                ArrayList<String> wkts = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Geometry spatialObject = (Geometry)iterator.next();
                    String wkt = writer.write(spatialObject);
                    if (spatialObject.getUserData() != null) {
                        wkts.add(wkt + "\t" + spatialObject.getUserData());
                        continue;
                    }
                    wkts.add(wkt);
                }
                return wkts.iterator();
            }
        }).saveAsTextFile(outputLocation);
    }

    public void saveAsGeoJSON(String outputLocation) {
        this.rawSpatialRDD.mapPartitions(new FlatMapFunction<Iterator<T>, String>(){

            public Iterator<String> call(Iterator<T> iterator) throws Exception {
                ArrayList<String> result = new ArrayList<String>();
                GeoJSONWriter writer = new GeoJSONWriter();
                while (iterator.hasNext()) {
                    Feature jsonFeature;
                    Geometry spatialObject = (Geometry)iterator.next();
                    if (spatialObject.getUserData() != null) {
                        HashMap<String, Object> userData = new HashMap<String, Object>();
                        userData.put("UserData", spatialObject.getUserData());
                        jsonFeature = new Feature(writer.write(spatialObject), userData);
                    } else {
                        jsonFeature = new Feature(writer.write(spatialObject), null);
                    }
                    String jsonstring = jsonFeature.toString();
                    result.add(jsonstring);
                }
                return result.iterator();
            }
        }).saveAsTextFile(outputLocation);
    }

    @Deprecated
    public RectangleRDD MinimumBoundingRectangle() {
        JavaRDD rectangleRDD = this.rawSpatialRDD.map(new Function<T, Polygon>(){

            public Polygon call(T spatialObject) {
                Coordinate[] coordinates = new Coordinate[5];
                GeometryFactory fact = new GeometryFactory();
                Envelope envelope = spatialObject.getEnvelopeInternal();
                Double x1 = envelope.getMinX();
                Double x2 = envelope.getMaxX();
                Double y1 = envelope.getMinY();
                Double y2 = envelope.getMaxY();
                coordinates[0] = new Coordinate(x1.doubleValue(), y1.doubleValue());
                coordinates[1] = new Coordinate(x1.doubleValue(), y2.doubleValue());
                coordinates[2] = new Coordinate(x2.doubleValue(), y2.doubleValue());
                coordinates[3] = new Coordinate(x2.doubleValue(), y1.doubleValue());
                coordinates[4] = coordinates[0];
                LinearRing linear = fact.createLinearRing(coordinates);
                Polygon polygonObject = new Polygon(linear, null, fact);
                return polygonObject;
            }
        });
        return new RectangleRDD((JavaRDD<Polygon>)rectangleRDD);
    }

    public boolean getCRStransformation() {
        return this.CRStransformation;
    }

    public String getSourceEpsgCode() {
        return this.sourceEpsgCode;
    }

    public String getTargetEpgsgCode() {
        return this.targetEpgsgCode;
    }

    public void flipCoordinates() {
        this.rawSpatialRDD = this.rawSpatialRDD.map((Function & Serializable)f -> {
            GeomUtils.flipCoordinates(f);
            return f;
        });
    }
}

