/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.core.joinJudgement.JudgementBase;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;

public class RightIndexLookupJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase
implements FlatMapFunction2<Iterator<T>, Iterator<SpatialIndex>, Pair<T, U>>,
Serializable {
    public RightIndexLookupJudgement(SpatialPredicate spatialPredicate) {
        super(spatialPredicate);
    }

    public Iterator<Pair<T, U>> call(Iterator<T> streamShapes, Iterator<SpatialIndex> indexIterator) throws Exception {
        ArrayList<Pair> result = new ArrayList<Pair>();
        if (!indexIterator.hasNext() || !streamShapes.hasNext()) {
            return result.iterator();
        }
        this.initPartition();
        SpatialIndex treeIndex = indexIterator.next();
        while (streamShapes.hasNext()) {
            Geometry streamShape = (Geometry)streamShapes.next();
            List candidates = treeIndex.query(streamShape.getEnvelopeInternal());
            for (Geometry candidate : candidates) {
                if (!this.match(streamShape, candidate)) continue;
                result.add(Pair.of((Object)streamShape, (Object)candidate));
            }
        }
        return result.iterator();
    }
}

