/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.common.enums.GeometryType;
import org.apache.sedona.common.utils.FormatUtils;
import org.apache.sedona.common.utils.GeoHashDecoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.gml2.GMLReader;
import org.locationtech.jts.io.kml.KMLReader;
import org.xml.sax.SAXException;

public class Constructors {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public static Geometry geomFromWKT(String wkt, int srid) throws ParseException {
        if (wkt == null) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry geomFromWKB(byte[] wkb) throws ParseException {
        return new WKBReader().read(wkb);
    }

    public static Geometry mLineFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("MULTILINESTRING")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry mPolyFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("MULTIPOLYGON")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry point(double x, double y) {
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPoint(new Coordinate(x, y));
    }

    public static Geometry pointZ(double x, double y, double z, int srid) {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return geometryFactory.createPoint(new Coordinate(x, y, z));
    }

    public static Geometry geomFromText(String geomString, String geomFormat, GeometryType geometryType) {
        FileDataSplitter fileDataSplitter = FileDataSplitter.getFileDataSplitter(geomFormat);
        FormatUtils formatMapper = new FormatUtils(fileDataSplitter, false, geometryType);
        try {
            return formatMapper.readGeometry(geomString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry geomFromText(String geomString, FileDataSplitter fileDataSplitter) {
        FormatUtils formatMapper = new FormatUtils(fileDataSplitter, false);
        try {
            return formatMapper.readGeometry(geomString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry pointFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.POINT);
    }

    public static Geometry polygonFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.POLYGON);
    }

    public static Geometry lineStringFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.LINESTRING);
    }

    public static Geometry lineFromText(String geomString) {
        FileDataSplitter fileDataSplitter = FileDataSplitter.WKT;
        Geometry geometry = Constructors.geomFromText(geomString, fileDataSplitter);
        if (geometry.getGeometryType().contains("LineString")) {
            return geometry;
        }
        return null;
    }

    public static Geometry polygonFromEnvelope(double minX, double minY, double maxX, double maxY) {
        Coordinate[] coordinates;
        coordinates = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), coordinates[0]};
        return GEOMETRY_FACTORY.createPolygon(coordinates);
    }

    public static Geometry geomFromGeoHash(String geoHash, Integer precision) {
        System.out.println(geoHash);
        System.out.println(precision);
        try {
            return GeoHashDecoder.decode(geoHash, precision);
        }
        catch (GeoHashDecoder.InvalidGeoHashException e) {
            return null;
        }
    }

    public static Geometry geomFromGML(String gml) throws IOException, ParserConfigurationException, SAXException {
        return new GMLReader().read(gml, GEOMETRY_FACTORY);
    }

    public static Geometry geomFromKML(String kml) throws ParseException {
        return new KMLReader().read(kml);
    }
}

