/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.sphere;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class Haversine {
    public static double distance(Geometry geom1, Geometry geom2, double AVG_EARTH_RADIUS) {
        Coordinate coordinate1 = geom1.getGeometryType().equals("Point") ? geom1.getCoordinate() : geom1.getCentroid().getCoordinate();
        Coordinate coordinate2 = geom2.getGeometryType().equals("Point") ? geom2.getCoordinate() : geom2.getCentroid().getCoordinate();
        double lat1 = coordinate1.getX();
        double lon1 = coordinate1.getY();
        double lat2 = coordinate2.getX();
        double lon2 = coordinate2.getY();
        double latDistance = Math.toRadians(lat2 - lat1);
        double lngDistance = Math.toRadians(lon2 - lon1);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lngDistance / 2.0) * Math.sin(lngDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return AVG_EARTH_RADIUS * c * 1.0;
    }

    public static double distance(Geometry geom1, Geometry geom2) {
        return Haversine.distance(geom1, geom2, 6371008.0);
    }
}

