/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamDataRow {
    public NcStreamProto.DataRow encodeData3(String name, boolean isVlen, Section section, Array data) {
        NcStreamProto.DataRow.Builder builder = NcStreamProto.DataRow.newBuilder();
        this.encodeData3(builder, name, isVlen, section, data);
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encodeData3(NcStreamProto.DataRow.Builder builder, String name, boolean isVlen, Section section, Array data) {
        DataType dataType = data.getDataType();
        builder.setFullName(name);
        builder.setDataType(NcStream.convertDataType(data.getDataType()));
        builder.setBigend(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);
        builder.setVersion(3);
        if (!isVlen) {
            builder.setNelems((int)data.getSize());
            builder.setSection(NcStream.encodeSection(section));
        }
        if (isVlen) {
            builder.setIsVlen(true);
            this.encodeVlenData(builder, section, data);
            return;
        } else if (dataType == DataType.STRING) {
            if (data instanceof ArrayChar) {
                ArrayChar cdata = (ArrayChar)data;
                for (String s2 : cdata) {
                    builder.addStringdata(s2);
                }
                Section ssection = section.toBuilder().removeLast().build();
                builder.setSection(NcStream.encodeSection(ssection));
                return;
            } else {
                if (!(data instanceof ArrayObject)) throw new IllegalStateException("Unknown class for STRING =" + data.getClass().getName());
                IndexIterator iter = data.getIndexIterator();
                while (iter.hasNext()) {
                    builder.addStringdata((String)iter.next());
                }
            }
            return;
        } else if (dataType == DataType.OPAQUE) {
            if (!(data instanceof ArrayObject)) throw new IllegalStateException("Unknown class for OPAQUE =" + data.getClass().getName());
            IndexIterator iter = data.getIndexIterator();
            while (iter.hasNext()) {
                ByteBuffer bb = (ByteBuffer)iter.next();
                builder.addOpaquedata(ByteString.copyFrom(bb));
            }
            return;
        } else if (dataType == DataType.STRUCTURE) {
            builder.setStructdata(this.encodeStructureData(name, data));
            return;
        } else {
            if (dataType == DataType.SEQUENCE) {
                throw new UnsupportedOperationException("Not implemented yet SEQUENCE =" + data.getClass().getName());
            }
            int nbytes = (int)data.getSizeBytes();
            ByteBuffer bb = ByteBuffer.allocate(nbytes);
            this.copyArrayToBB(data, bb);
            bb.flip();
            builder.setPrimdata(ByteString.copyFrom(bb));
        }
    }

    void encodeVlenData(NcStreamProto.DataRow.Builder builder, Section section, Array data) {
        if (!(data instanceof ArrayObject)) {
            throw new IllegalStateException("Unknown class for OPAQUE =" + data.getClass().getName());
        }
        IndexIterator iter = data.getIndexIterator();
        int count = 0;
        while (iter.hasNext()) {
            Array varray = (Array)iter.next();
            int vlensize = (int)varray.getSize();
            builder.addVlens(vlensize);
            count += vlensize;
        }
        builder.setNelems(count);
        Section ssection = section.toBuilder().removeLast().build();
        builder.setSection(NcStream.encodeSection(ssection));
        assert (section.computeSize() == (long)count);
        int nbytes = count * data.getDataType().getSize();
        ByteBuffer bb = ByteBuffer.allocate(nbytes);
        iter = data.getIndexIterator();
        while (iter.hasNext()) {
            Array varray = (Array)iter.next();
            this.copyArrayToBB(varray, bb);
        }
    }

    void copyArrayToBB(Array data, ByteBuffer out) {
        Class classType = data.getElementType();
        IndexIterator iterA = data.getIndexIterator();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                out.putDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                out.putFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                out.putLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                out.putInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                out.putShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            byte[] pa = IospHelper.convertCharToByte((char[])data.get1DJavaArray(DataType.CHAR));
            out.put(pa, 0, pa.length);
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                out.put(iterA.getByteNext());
            }
        } else {
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
    }

    NcStreamProto.ArrayStructureRow.Builder encodeStructureData(String structName, Array data) {
        assert (data instanceof ArrayStructure);
        ArrayStructure as = (ArrayStructure)data;
        int nelems = (int)as.getSize();
        ArrayList<MemberData> memberData = new ArrayList<MemberData>();
        StructureMembers sm = as.getStructureMembers();
        for (StructureMembers.Member m3 : sm.getMembers()) {
            memberData.add(new MemberData(m3, nelems));
        }
        for (int recno = 0; recno < nelems; ++recno) {
            for (MemberData md : memberData) {
                if (md.member.isVariableLength()) {
                    md.vlenList.add(as.getArray(recno, md.member));
                    continue;
                }
                this.extractData(as, recno, md);
            }
        }
        NcStreamProto.ArrayStructureRow.Builder builder = NcStreamProto.ArrayStructureRow.newBuilder();
        for (MemberData md : memberData) {
            NcStreamProto.Member.Builder member = NcStreamProto.Member.newBuilder();
            member.setShortName(md.member.getName());
            member.setDataType(NcStream.convertDataType(md.member.getDataType()));
            builder.addMembers(member);
        }
        return builder;
    }

    void extractData(ArrayStructure as, int recno, MemberData md) {
        block27: {
            Class classType;
            ByteBuffer bb;
            StructureMembers.Member m3;
            block25: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block26: {
                                                m3 = md.member;
                                                bb = md.bb;
                                                classType = md.dtype.getPrimitiveClassType();
                                                if (!m3.isScalar()) break block25;
                                                if (classType != Double.TYPE) break block26;
                                                bb.putDouble(as.getScalarDouble(recno, m3));
                                                break block27;
                                            }
                                            if (classType != Float.TYPE) break block28;
                                            bb.putFloat(as.getScalarFloat(recno, m3));
                                            break block27;
                                        }
                                        if (classType != Byte.TYPE) break block29;
                                        bb.put(as.getScalarByte(recno, m3));
                                        break block27;
                                    }
                                    if (classType != Short.TYPE) break block30;
                                    bb.putShort(as.getScalarShort(recno, m3));
                                    break block27;
                                }
                                if (classType != Integer.TYPE) break block31;
                                bb.putInt(as.getScalarInt(recno, m3));
                                break block27;
                            }
                            if (classType != Long.TYPE) break block32;
                            bb.putLong(as.getScalarLong(recno, m3));
                            break block27;
                        }
                        if (md.dtype != DataType.CHAR) break block33;
                        bb.put((byte)as.getScalarChar(recno, m3));
                        break block27;
                    }
                    if (md.dtype != DataType.STRING) break block34;
                    md.stringList.add(as.getScalarString(recno, m3));
                    break block27;
                }
                if (md.dtype != DataType.OPAQUE) break block27;
                md.opaqueList.add(ByteString.copyFrom((ByteBuffer)as.getScalarObject(recno, m3)));
                break block27;
            }
            if (classType == Double.TYPE) {
                double[] data;
                for (double aData : data = as.getJavaArrayDouble(recno, m3)) {
                    bb.putDouble(aData);
                }
            } else if (classType == Float.TYPE) {
                float[] data;
                for (float aData : data = as.getJavaArrayFloat(recno, m3)) {
                    bb.putFloat(aData);
                }
            } else if (classType == Byte.TYPE) {
                byte[] data;
                for (byte aData : data = as.getJavaArrayByte(recno, m3)) {
                    bb.put(aData);
                }
            } else if (classType == Short.TYPE) {
                short[] data;
                for (short aData : data = as.getJavaArrayShort(recno, m3)) {
                    bb.putShort(aData);
                }
            } else if (classType == Integer.TYPE) {
                int[] data;
                for (int aData : data = as.getJavaArrayInt(recno, m3)) {
                    bb.putInt(aData);
                }
            } else if (classType == Long.TYPE) {
                long[] data;
                for (long aData : data = as.getJavaArrayLong(recno, m3)) {
                    bb.putLong(aData);
                }
            } else if (md.dtype == DataType.CHAR) {
                char[] data;
                for (char aData : data = as.getJavaArrayChar(recno, m3)) {
                    bb.put((byte)aData);
                }
            } else if (md.dtype == DataType.STRING) {
                String[] data = as.getJavaArrayString(recno, m3);
                Collections.addAll(md.stringList, data);
            } else if (md.dtype == DataType.OPAQUE) {
                ArrayObject ao = as.getArrayObject(recno, m3);
                while (ao.hasNext()) {
                    md.opaqueList.add(ByteString.copyFrom((ByteBuffer)ao.next()));
                }
            }
        }
    }

    private class MemberData {
        StructureMembers.Member member;
        int nelems;
        DataType dtype;
        boolean isVlen;
        ByteBuffer bb;
        List<String> stringList;
        List<ByteString> opaqueList;
        List<Array> vlenList;
        List<Integer> vlens;

        public MemberData(StructureMembers.Member member, int nelems) {
            this.member = member;
            this.nelems = nelems;
            this.dtype = member.getDataType();
            this.isVlen = member.isVariableLength();
            if (this.isVlen) {
                this.vlenList = new ArrayList<Array>(nelems);
            } else if (this.dtype == DataType.STRING) {
                this.stringList = new ArrayList<String>(nelems * member.getSize());
            } else if (this.dtype == DataType.OPAQUE) {
                this.opaqueList = new ArrayList<ByteString>(nelems * member.getSize());
            } else if (this.dtype != DataType.STRUCTURE) {
                this.bb = ByteBuffer.allocate(nelems * member.getSizeBytes());
            }
        }

        int completeVlens() {
            this.vlens = new ArrayList<Integer>(this.nelems);
            int total = 0;
            for (Array va : this.vlenList) {
                this.vlens.add((int)va.getSize());
                total = (int)((long)total + va.getSize());
            }
            this.bb = ByteBuffer.allocate(this.nelems * this.member.getSizeBytes());
            for (Array va : this.vlenList) {
                NcStreamDataRow.this.copyArrayToBB(va, this.bb);
            }
            return total;
        }
    }
}

