/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationPointFeature;

public class StationFeatureCopyFactory {
    private static final int POINTER_SIZE = 8;
    private static final int OBJECT_SIZE = 40;
    private static final int ARRAY_SIZE = 8;
    private final Map<String, StationFeatureImpl> stationMap = new HashMap<String, StationFeatureImpl>();
    private final StructureMembers sm;
    private final int sizeInBytes;

    public StationFeatureCopyFactory(StationPointFeature proto) throws IOException {
        StructureData sdata = proto.getFeatureData();
        this.sm = sdata.getStructureMembers().toBuilder(false).build();
        this.sizeInBytes = 364 + this.sm.getStructureSize();
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public StationPointFeature deepCopy(StationPointFeature from) throws IOException {
        StationFeature s2 = from.getStation();
        StationFeatureImpl sUse = this.stationMap.get(s2.getName());
        if (sUse == null) {
            sUse = new StationFeatureImpl(s2);
            this.stationMap.put(s2.getName(), sUse);
        }
        sUse.incrNobs();
        StationPointFeatureCopy deep = new StationPointFeatureCopy(sUse, from);
        deep.data = StructureDataDeep.copy(from.getFeatureData(), this.sm);
        return deep;
    }

    private static class StationPointFeatureCopy
    extends PointFeatureImpl
    implements StationPointFeature {
        final StationFeature station;
        StructureData data;

        StationPointFeatureCopy(StationFeature station, PointFeature pf) {
            super(pf.getFeatureCollection(), station, pf.getObservationTime(), pf.getNominalTime(), pf.getFeatureCollection().getTimeUnit());
            this.station = station;
        }

        @Override
        @Nonnull
        public StructureData getDataAll() {
            return this.data;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.data;
        }

        @Override
        public StationFeature getStation() {
            return this.station;
        }
    }
}

