/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.python.wrapper.translation;

import java.nio.ByteBuffer;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.python.wrapper.SerializationException;
import org.apache.sedona.python.wrapper.SerializationException$;
import org.apache.sedona.python.wrapper.translation.CircleSerializer;
import org.apache.sedona.python.wrapper.translation.GeometrySerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t3Q!\u0002\u0004\u0001\u0015IAQ\u0001\b\u0001\u0005\u0002yAQ!\t\u0001\u0005\u0002\tBQ!\u000e\u0001\u0005\u0002YBQ!\u000e\u0001\u0005\u0002e\u0012\u0001\u0004U=uQ>tw)Z8nKR\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\t9\u0001\"A\u0006ue\u0006t7\u000f\\1uS>t'BA\u0005\u000b\u0003\u001d9(/\u00199qKJT!a\u0003\u0007\u0002\rALH\u000f[8o\u0015\tia\"\u0001\u0004tK\u0012|g.\u0019\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xmE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u001b\u0013\tYRC\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0002C\u0001\u0011\u0001\u001b\u00051\u0011!C:fe&\fG.\u001b>f)\t\u0019\u0013\u0006E\u0002\u0015I\u0019J!!J\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Q9\u0013B\u0001\u0015\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u0011\u001d,w.\\3uef\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\t\u001d,w.\u001c\u0006\u0003aE\n1A\u001b;t\u0015\t\u0011\u0004#\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007.\u0003\u00025[\tAq)Z8nKR\u0014\u00180A\u0006eKN,'/[1mSj,GCA\u00168\u0011\u0015A4\u00011\u0001$\u0003\u00191\u0018\r\\;fgR!1FO A\u0011\u0015YD\u00011\u0001=\u0003!I7oQ5sG2,\u0007C\u0001\u000b>\u0013\tqTCA\u0002J]RDQ\u0001\u000f\u0003A\u0002\rBQ!\u0011\u0003A\u0002q\naa\u001c4gg\u0016$\b")
public class PythonGeometrySerializer
implements Serializable {
    public byte[] serialize(Geometry geometry) {
        byte[] byArray;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Circle) {
            Circle circle = (Circle)geometry2;
            byArray = new CircleSerializer(circle).serialize();
        } else {
            byArray = new GeometrySerializer(geometry).serialize();
        }
        return byArray;
    }

    public Geometry deserialize(byte[] values) {
        byte isCircle = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values)).head());
        return this.deserialize(isCircle, values, 1);
    }

    public Geometry deserialize(int isCircle, byte[] values, int offset) {
        Geometry geometry;
        WKBReader reader = new WKBReader();
        if (isCircle == 1) {
            Geometry geom = reader.read((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values)).slice(offset + 8, values.length));
            double radius = ByteBuffer.wrap((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values)).slice(offset, offset + 8)).getDouble();
            geometry = new Circle(geom, Predef$.MODULE$.double2Double(radius));
        } else if (isCircle == 0) {
            geometry = reader.read((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(values)).slice(offset, values.length));
        } else {
            throw new SerializationException("Can not deserialize object", SerializationException$.MODULE$.apply$default$2());
        }
        return geometry;
    }
}

