/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.AbstractReaders;

public class RepeatedReadSchemas {
    public static <T, ELE_TYPE> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, AbstractReaders<ELE_TYPE> readers) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (readers.arrayClass.isAssignableFrom(javaType.getRawClass())) {
            return new ArrayRepeatedSchema(protoField, propertyDescriptor, readers);
        }
        if (Collection.class.isAssignableFrom(javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new CollectionRepeatedSchema(protoField, propertyDescriptor, readers);
        }
        ProtoUtils.throwNotSupportMerge(protoField, javaType);
        return null;
    }

    static class ArrayRepeatedSchema<T, ELE_TYPE>
    extends AbstractRepeatedSchema<T, ELE_TYPE> {
        private final Getter<T, ELE_TYPE[]> getter;
        private final Setter<T, ELE_TYPE[]> setter;

        public ArrayRepeatedSchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractReaders<ELE_TYPE> readers) {
            super(protoField, propertyDescriptor, readers);
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public final int mergeFrom(InputEx input, T message) throws IOException {
            Object[] array = (Object[])this.getter.get(message);
            ArrayList collection = array == null ? new ArrayList() : new ArrayList<Object>(Arrays.asList(array));
            int fieldNumber = this.readers.collectionReader.read(input, collection);
            Object[] newArray = (Object[])Array.newInstance(this.readers.arrayClass.getComponentType(), collection.size());
            this.setter.set(message, (Object)collection.toArray(newArray));
            return fieldNumber;
        }
    }

    static class CollectionRepeatedSchema<T, ELE_TYPE>
    extends AbstractRepeatedSchema<T, ELE_TYPE> {
        private final Getter<T, Collection<ELE_TYPE>> getter;
        private final Setter<T, Collection<ELE_TYPE>> setter;

        public CollectionRepeatedSchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractReaders<ELE_TYPE> readers) {
            super(protoField, propertyDescriptor, readers);
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public final int mergeFrom(InputEx input, T message) throws IOException {
            ArrayList collection = (ArrayList)this.getter.get(message);
            if (collection == null) {
                collection = new ArrayList();
                this.setter.set(message, collection);
            }
            return this.readers.collectionReader.read(input, collection);
        }
    }

    static class AbstractRepeatedSchema<T, ELE_TYPE>
    extends FieldSchema<T> {
        protected final AbstractReaders<ELE_TYPE> readers;

        public AbstractRepeatedSchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractReaders<ELE_TYPE> readers) {
            super(protoField, propertyDescriptor.getJavaType());
            this.readers = readers;
        }
    }
}

