/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.metric.HystrixCollapserEvent;
import com.netflix.hystrix.metric.HystrixThreadEventStream;
import com.netflix.hystrix.metric.consumer.CumulativeCollapserEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserBatchSizeDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserEventCounterStream;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func2;

public class HystrixCollapserMetrics
extends HystrixMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCollapserMetrics.class);
    private static final ConcurrentHashMap<String, HystrixCollapserMetrics> metrics = new ConcurrentHashMap();
    private static final HystrixEventType.Collapser[] ALL_EVENT_TYPES = HystrixEventType.Collapser.values();
    public static final Func2<long[], HystrixCollapserEvent, long[]> appendEventToBucket = new Func2<long[], HystrixCollapserEvent, long[]>(){

        public long[] call(long[] initialCountArray, HystrixCollapserEvent collapserEvent) {
            HystrixEventType.Collapser eventType = collapserEvent.getEventType();
            int count = collapserEvent.getCount();
            int n = eventType.ordinal();
            initialCountArray[n] = initialCountArray[n] + (long)count;
            return initialCountArray;
        }
    };
    public static final Func2<long[], long[], long[]> bucketAggregator = new Func2<long[], long[], long[]>(){

        public long[] call(long[] cumulativeEvents, long[] bucketEventCounts) {
            for (HystrixEventType.Collapser eventType : ALL_EVENT_TYPES) {
                int n = eventType.ordinal();
                cumulativeEvents[n] = cumulativeEvents[n] + bucketEventCounts[eventType.ordinal()];
            }
            return cumulativeEvents;
        }
    };
    private final HystrixCollapserKey collapserKey;
    private final HystrixCollapserProperties properties;
    private final RollingCollapserEventCounterStream rollingCollapserEventCounterStream;
    private final CumulativeCollapserEventCounterStream cumulativeCollapserEventCounterStream;
    private final RollingCollapserBatchSizeDistributionStream rollingCollapserBatchSizeDistributionStream;

    public static HystrixCollapserMetrics getInstance(HystrixCollapserKey key, HystrixCollapserProperties properties) {
        HystrixCollapserMetrics collapserMetrics = metrics.get(key.name());
        if (collapserMetrics != null) {
            return collapserMetrics;
        }
        collapserMetrics = new HystrixCollapserMetrics(key, properties);
        HystrixCollapserMetrics existing = metrics.putIfAbsent(key.name(), collapserMetrics);
        if (existing == null) {
            return collapserMetrics;
        }
        return existing;
    }

    public static Collection<HystrixCollapserMetrics> getInstances() {
        return Collections.unmodifiableCollection(metrics.values());
    }

    static void reset() {
        metrics.clear();
    }

    HystrixCollapserMetrics(HystrixCollapserKey key, HystrixCollapserProperties properties) {
        super(null);
        this.collapserKey = key;
        this.properties = properties;
        this.rollingCollapserEventCounterStream = RollingCollapserEventCounterStream.getInstance(key, properties);
        this.cumulativeCollapserEventCounterStream = CumulativeCollapserEventCounterStream.getInstance(key, properties);
        this.rollingCollapserBatchSizeDistributionStream = RollingCollapserBatchSizeDistributionStream.getInstance(key, properties);
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public HystrixCollapserProperties getProperties() {
        return this.properties;
    }

    public long getRollingCount(HystrixEventType.Collapser collapserEventType) {
        return this.rollingCollapserEventCounterStream.getLatest(collapserEventType);
    }

    public long getCumulativeCount(HystrixEventType.Collapser collapserEventType) {
        return this.cumulativeCollapserEventCounterStream.getLatest(collapserEventType);
    }

    @Override
    public long getCumulativeCount(HystrixRollingNumberEvent event) {
        return this.getCumulativeCount(HystrixEventType.Collapser.from(event));
    }

    @Override
    public long getRollingCount(HystrixRollingNumberEvent event) {
        return this.getRollingCount(HystrixEventType.Collapser.from(event));
    }

    public int getBatchSizePercentile(double percentile) {
        return this.rollingCollapserBatchSizeDistributionStream.getLatestPercentile(percentile);
    }

    public int getBatchSizeMean() {
        return this.rollingCollapserBatchSizeDistributionStream.getLatestMean();
    }

    public int getShardSizePercentile(double percentile) {
        return 0;
    }

    public int getShardSizeMean() {
        return 0;
    }

    public void markRequestBatched() {
    }

    public void markResponseFromCache() {
        HystrixThreadEventStream.getInstance().collapserResponseFromCache(this.collapserKey);
    }

    public void markBatch(int batchSize) {
        HystrixThreadEventStream.getInstance().collapserBatchExecuted(this.collapserKey, batchSize);
    }

    public void markShards(int numShards) {
    }
}

