/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import org.synchronoss.cloud.nio.multipart.MultipartUtils;

public class MultipartContext {
    private final String contentType;
    private final int contentLength;
    private final String charEncoding;

    public MultipartContext(String contentType, int contentLength, String charEncoding) {
        if (!MultipartUtils.isMultipart(contentType)) {
            throw new IllegalStateException("Invalid content type '" + contentType + "'. Expected a multipart request");
        }
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.charEncoding = charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String toString() {
        return "MultipartContext{contentType='" + this.contentType + '\'' + ", contentLength=" + this.contentLength + ", charEncoding='" + this.charEncoding + '\'' + '}';
    }
}

