/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.ws;

import io.vertx.core.http.WebSocketConnectOptions;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.servicecomb.foundation.common.http.HttpUtils;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;

public class VertxClientWebSocketRequestToHttpServletRequest
extends AbstractHttpServletRequest {
    private final WebSocketConnectOptions clientRequest;
    private String characterEncoding;

    public VertxClientWebSocketRequestToHttpServletRequest(WebSocketConnectOptions clientRequest) {
        this.clientRequest = clientRequest;
    }

    @Override
    public String getRequestURI() {
        return HttpUtils.splitPathFromUri((String)this.clientRequest.getURI());
    }

    @Override
    public String getQueryString() {
        return HttpUtils.splitQueryFromUri((String)this.clientRequest.getURI());
    }

    @Override
    public String getHeader(String name) {
        return this.clientRequest.getHeaders().get(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.clientRequest.getHeaders().getAll(name));
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.clientRequest.getHeaders().names());
    }

    @Override
    public void setHeader(String name, String value) {
        this.clientRequest.getHeaders().set(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.clientRequest.getHeaders().add(name, value);
    }

    @Override
    public String getContextPath() {
        return "";
    }

    @Override
    public String getMethod() {
        return this.clientRequest.getMethod().name();
    }

    @Override
    public String getContentType() {
        return this.clientRequest.getHeaders().get("Content-Type");
    }

    @Override
    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = HttpUtils.getCharsetFromContentType((String)this.getContentType());
        }
        return this.characterEncoding;
    }
}

