/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff.myers;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.diff.ChangeDelta;
import org.assertj.core.util.diff.Chunk;
import org.assertj.core.util.diff.DeleteDelta;
import org.assertj.core.util.diff.Delta;
import org.assertj.core.util.diff.DiffAlgorithm;
import org.assertj.core.util.diff.InsertDelta;
import org.assertj.core.util.diff.Patch;
import org.assertj.core.util.diff.myers.DiffNode;
import org.assertj.core.util.diff.myers.Equalizer;
import org.assertj.core.util.diff.myers.PathNode;
import org.assertj.core.util.diff.myers.Snake;

public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> equalizer = (original, revised) -> original.equals(revised);

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        Preconditions.checkArgument(original != null, "original list must not be null", new Object[0]);
        Preconditions.checkArgument(revised != null, "revised list must not be null", new Object[0]);
        try {
            PathNode path = this.buildPath(original, revised);
            return this.buildRevision(path, original, revised);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return new Patch();
        }
    }

    public PathNode buildPath(List<T> orig, List<T> rev) {
        Preconditions.checkArgument(orig != null, "original sequence is null", new Object[0]);
        Preconditions.checkArgument(rev != null, "revised sequence is null", new Object[0]);
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                PathNode prev;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new IllegalStateException("could not find a diff path");
    }

    private boolean equals(T orig, T rev) {
        return this.equalizer.equals(orig, rev);
    }

    public Patch<T> buildRevision(PathNode path, List<T> orig, List<T> rev) {
        Preconditions.checkArgument(path != null, "path is null", new Object[0]);
        Preconditions.checkArgument(orig != null, "original sequence is null", new Object[0]);
        Preconditions.checkArgument(rev != null, "revised sequence is null", new Object[0]);
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            Preconditions.checkState(!path.isSnake(), "bad diffpath: found snake when looking for diff", new Object[0]);
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch;
    }

    private List<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }
}

