/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.header.HeaderDescriptionRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.HeaderValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.HeaderValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SchemaValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.header.HeaderSchemaValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultHeaderValidatorFactory
implements HeaderValidatorFactory {
    private final SchemaValidatorFactory schemaValidatorFactory;

    public DefaultHeaderValidatorFactory(SchemaValidatorFactory schemaValidatorFactory) {
        this.schemaValidatorFactory = schemaValidatorFactory;
    }

    public List<HeaderValidator> create(FactoryOptions options) {
        ArrayList<HeaderValidator> validators = new ArrayList<HeaderValidator>();
        validators.add((HeaderValidator)new HeaderSchemaValidator(this.schemaValidatorFactory.create(options)));
        this.addHeaderDescriptionRequiredValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addHeaderDescriptionRequiredValidator(List<HeaderValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("header.description.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new HeaderDescriptionRequiredValidator());
        }
    }
}

