/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import org.apache.karaf.log.core.LogEventFormatter;
import org.apache.karaf.log.core.internal.layout.PatternConverter;
import org.apache.karaf.log.core.internal.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class LogEventFormatterImpl
implements LogEventFormatter {
    protected String pattern;
    protected String fatalColor;
    protected String errorColor;
    protected String warnColor;
    protected String infoColor;
    protected String debugColor;
    protected String traceColor;
    private static final String FATAL = "fatal";
    private static final String ERROR = "error";
    private static final String WARN = "warn";
    private static final String INFO = "info";
    private static final String DEBUG = "debug";
    private static final String TRACE = "trace";
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    private static final char COMMAND_CHAR = 'm';

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFatalColor() {
        return this.fatalColor;
    }

    public void setFatalColor(String fatalColor) {
        this.fatalColor = fatalColor;
    }

    public String getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(String errorColor) {
        this.errorColor = errorColor;
    }

    public String getWarnColor() {
        return this.warnColor;
    }

    public void setWarnColor(String warnColor) {
        this.warnColor = warnColor;
    }

    public String getInfoColor() {
        return this.infoColor;
    }

    public void setInfoColor(String infoColor) {
        this.infoColor = infoColor;
    }

    public String getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(String debugColor) {
        this.debugColor = debugColor;
    }

    public String getTraceColor() {
        return this.traceColor;
    }

    public void setTraceColor(String traceColor) {
        this.traceColor = traceColor;
    }

    @Override
    public String format(PaxLoggingEvent event, String overridenPattern, boolean noColor) {
        PatternConverter cnv = new PatternParser(overridenPattern != null ? overridenPattern : this.pattern).parse();
        String color = this.getColor(event, noColor);
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        if (color != null) {
            sb.append('\u001b');
            sb.append('[');
            sb.append(color);
            sb.append('m');
        }
        PatternConverter pc = cnv;
        while (pc != null) {
            pc.format(sb, event);
            pc = pc.next;
        }
        if (event.getThrowableStrRep() != null) {
            for (String r : event.getThrowableStrRep()) {
                sb.append(r).append('\n');
            }
        }
        if (color != null) {
            sb.append('\u001b');
            sb.append('[');
            sb.append("0");
            sb.append('m');
        }
        return sb.toString();
    }

    private String getColor(PaxLoggingEvent event, boolean noColor) {
        String color = null;
        if (!noColor && event != null && event.getLevel() != null && event.getLevel().toString() != null) {
            String lvl = event.getLevel().toString().toLowerCase();
            if (FATAL.equals(lvl)) {
                color = this.fatalColor;
            } else if (ERROR.equals(lvl)) {
                color = this.errorColor;
            } else if (WARN.equals(lvl)) {
                color = this.warnColor;
            } else if (INFO.equals(lvl)) {
                color = this.infoColor;
            } else if (DEBUG.equals(lvl)) {
                color = this.debugColor;
            } else if (TRACE.equals(lvl)) {
                color = this.traceColor;
            }
            if (color != null && color.length() == 0) {
                color = null;
            }
        }
        return color;
    }
}

