/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.common.v1.internal.AnyValue;

final class BytesAnyValueStatelessMarshaler
implements StatelessMarshaler<ByteBuffer> {
    static final BytesAnyValueStatelessMarshaler INSTANCE = new BytesAnyValueStatelessMarshaler();

    private BytesAnyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, ByteBuffer value, MarshalerContext context) throws IOException {
        byte[] bytes = context.getData(byte[].class);
        output.writeBytes(AnyValue.BYTES_VALUE, bytes);
    }

    @Override
    public int getBinarySerializedSize(ByteBuffer value, MarshalerContext context) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        context.addData(bytes);
        return AnyValue.BYTES_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(bytes);
    }
}

