/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ComputeNodeInstanceStateChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.LabelsEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.WorkerIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class ComputeNodeStateDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return ComputeNode.getComputeNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        Optional<DispatchEvent> result;
        String instanceId = ComputeNode.getInstanceIdByComputeNode((String)event.getKey());
        if (!Strings.isNullOrEmpty((String)instanceId) && (result = this.createInstanceDispatchEvent(event, instanceId)).isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createInstanceDispatchEvent(DataChangedEvent event, String instanceId) {
        if (event.getKey().equals(ComputeNode.getComputeNodeStateNodePath((String)instanceId)) && DataChangedEvent.Type.DELETED != event.getType()) {
            return Optional.of(new ComputeNodeInstanceStateChangedEvent(instanceId, event.getValue()));
        }
        if (event.getKey().equals(ComputeNode.getInstanceLabelsNodePath((String)instanceId)) && DataChangedEvent.Type.DELETED != event.getType()) {
            return Optional.of(new LabelsEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class)));
        }
        if (event.getKey().equals(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId))) {
            return Optional.of(new WorkerIdEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? null : Integer.valueOf(event.getValue())));
        }
        return Optional.empty();
    }
}

