/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class GenericSchemaBuilderMaterial {
    private final DatabaseType protocolType;
    private final Map<String, DatabaseType> storageTypes;
    private final Map<String, DataSource> dataSourceMap;
    private final Collection<ShardingSphereRule> rules;
    private final ConfigurationProperties props;
    private final String defaultSchemaName;

    public GenericSchemaBuilderMaterial(DatabaseType protocolType, Map<String, StorageUnit> storageUnits, Collection<ShardingSphereRule> rules, ConfigurationProperties props, String defaultSchemaName) {
        this(protocolType, storageUnits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getStorageType(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), storageUnits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), rules, props, defaultSchemaName);
    }

    public boolean isSameProtocolAndStorageTypes() {
        return this.storageTypes.values().stream().allMatch(this.protocolType::equals);
    }

    @Generated
    public GenericSchemaBuilderMaterial(DatabaseType protocolType, Map<String, DatabaseType> storageTypes, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules, ConfigurationProperties props, String defaultSchemaName) {
        this.protocolType = protocolType;
        this.storageTypes = storageTypes;
        this.dataSourceMap = dataSourceMap;
        this.rules = rules;
        this.props = props;
        this.defaultSchemaName = defaultSchemaName;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public Map<String, DatabaseType> getStorageTypes() {
        return this.storageTypes;
    }

    @Generated
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Generated
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }
}

