/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.ProjectionIdentifierExtractEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ExpressionProjection
implements Projection {
    private final ExpressionProjectionSegment expressionSegment;
    private final IdentifierValue alias;
    private final DatabaseType databaseType;

    @Override
    public String getColumnName() {
        return this.getColumnLabel();
    }

    @Override
    public String getColumnLabel() {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(this.databaseType);
        return this.getAlias().map(extractEngine::getIdentifierValue).orElseGet(() -> extractEngine.getColumnNameFromExpression(this.expressionSegment.getText()));
    }

    @Override
    public String getExpression() {
        return this.expressionSegment.getText();
    }

    @Override
    public Optional<IdentifierValue> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Generated
    public ExpressionProjection(ExpressionProjectionSegment expressionSegment, IdentifierValue alias, DatabaseType databaseType) {
        this.expressionSegment = expressionSegment;
        this.alias = alias;
        this.databaseType = databaseType;
    }

    @Generated
    public ExpressionProjectionSegment getExpressionSegment() {
        return this.expressionSegment;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionProjection)) {
            return false;
        }
        ExpressionProjection other = (ExpressionProjection)o;
        ExpressionProjectionSegment this$expressionSegment = this.getExpressionSegment();
        ExpressionProjectionSegment other$expressionSegment = other.getExpressionSegment();
        if (this$expressionSegment == null ? other$expressionSegment != null : !this$expressionSegment.equals(other$expressionSegment)) {
            return false;
        }
        Optional<IdentifierValue> this$alias = this.getAlias();
        Optional<IdentifierValue> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpressionProjectionSegment $expressionSegment = this.getExpressionSegment();
        result = result * 59 + ($expressionSegment == null ? 43 : $expressionSegment.hashCode());
        Optional<IdentifierValue> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExpressionProjection(expressionSegment=" + this.getExpressionSegment() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ")";
    }
}

