/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.checker.algorithm;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.sharding.cache.checker.algorithm.CacheableShardingAlgorithmClassProvider;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class CacheableShardingAlgorithmChecker {
    private static final Collection<Class<? extends ShardingAlgorithm>> CACHEABLE_SHARDING_ALGORITHM_CLASSES;

    public static boolean isCacheableShardingAlgorithm(ShardingAlgorithm shardingAlgorithm) {
        return CACHEABLE_SHARDING_ALGORITHM_CLASSES.contains(shardingAlgorithm.getClass());
    }

    @Generated
    private CacheableShardingAlgorithmChecker() {
    }

    static {
        HashSet<Class<? extends ShardingAlgorithm>> result = new HashSet<Class<? extends ShardingAlgorithm>>();
        for (CacheableShardingAlgorithmClassProvider each : ShardingSphereServiceLoader.getServiceInstances(CacheableShardingAlgorithmClassProvider.class)) {
            result.addAll(each.getCacheableShardingAlgorithmClasses());
        }
        CACHEABLE_SHARDING_ALGORITHM_CLASSES = result;
    }
}

