/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.pagination;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;

public final class LimitDecoratorMergedResult
extends DecoratorMergedResult {
    private final PaginationContext paginationContext;
    private final boolean skipAll;
    private int rowNumber;

    public LimitDecoratorMergedResult(MergedResult mergedResult, PaginationContext paginationContext) throws SQLException {
        super(mergedResult);
        this.paginationContext = paginationContext;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        int i = 0;
        while ((long)i < this.paginationContext.getActualOffset()) {
            if (!this.getMergedResult().next()) {
                return true;
            }
            ++i;
        }
        this.rowNumber = 0;
        return false;
    }

    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (!this.paginationContext.getActualRowCount().isPresent()) {
            return this.getMergedResult().next();
        }
        return (long)(++this.rowNumber) <= (Long)this.paginationContext.getActualRowCount().get() && this.getMergedResult().next();
    }
}

