/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.metadata.EngagedViewException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedCreateViewException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.TableExtractor;

public final class ShardingCreateViewStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect());
        Collection tableSegments = extractor.getRewriteTables();
        String viewName = ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getView().getTableName().getIdentifier().getValue();
        if (this.isShardingTablesNotBindingWithView(tableSegments, shardingRule, viewName)) {
            throw new EngagedViewException("sharding");
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SelectStatement selectStatement = ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect();
        if (this.isContainsNotSupportedViewStatement(selectStatement, routeContext)) {
            throw new UnsupportedCreateViewException();
        }
    }

    private boolean isContainsNotSupportedViewStatement(SelectStatement selectStatement, RouteContext routeContext) {
        if (routeContext.getRouteUnits().size() <= 1) {
            return false;
        }
        return this.hasGroupBy(selectStatement) || this.hasAggregation(selectStatement) || this.hasDistinct(selectStatement) || this.hasLimit(selectStatement);
    }

    private boolean hasGroupBy(SelectStatement selectStatement) {
        return selectStatement.getGroupBy().map(groupBySegment -> !groupBySegment.getGroupByItems().isEmpty()).orElse(false);
    }

    private boolean hasAggregation(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof AggregationProjectionSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDistinct(SelectStatement selectStatement) {
        return selectStatement.getProjections().isDistinctRow();
    }

    private boolean hasLimit(SelectStatement selectStatement) {
        return selectStatement.getLimit().isPresent();
    }

    @Generated
    public ShardingCreateViewStatementValidator() {
    }
}

