/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class StatesNodePath {
    private static final String ROOT_NODE = "/states";
    private static final String CLUSTER_STATE_NODE = "cluster_state";
    private static final String LISTENER_ASSISTED_NODE = "listener_assisted";
    private static final String DATABASE_PATTERN = "(\\w+)";

    public static String getClusterStatePath() {
        return String.join((CharSequence)"/", ROOT_NODE, CLUSTER_STATE_NODE);
    }

    public static String getListenerAssistedNodeRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, LISTENER_ASSISTED_NODE);
    }

    public static String getListenerAssistedNodePath(String databaseName) {
        return String.join((CharSequence)"/", StatesNodePath.getListenerAssistedNodeRootPath(), databaseName);
    }

    public static Optional<String> findDatabaseName(String listenerAssistedNodePath) {
        Pattern pattern = Pattern.compile(StatesNodePath.getListenerAssistedNodePath(DATABASE_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(listenerAssistedNodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @Generated
    private StatesNodePath() {
    }
}

