/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalDataSourceAggregator;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.attribute.datasource.aggregate.AggregatedDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.rule.SingleDataNodeRuleAttribute;
import org.apache.shardingsphere.single.rule.SingleExportableRuleAttribute;
import org.apache.shardingsphere.single.rule.SingleMutableDataNodeRuleAttribute;
import org.apache.shardingsphere.single.rule.SingleTableMapperRuleAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class SingleRule
implements DatabaseRule {
    private final SingleRuleConfiguration configuration;
    private final String defaultDataSource;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final DatabaseType protocolType;
    private final SingleMutableDataNodeRuleAttribute mutableDataNodeRuleAttribute;
    private final RuleAttributes attributes;

    public SingleRule(SingleRuleConfiguration ruleConfig, String databaseName, DatabaseType protocolType, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        this.defaultDataSource = ruleConfig.getDefaultDataSource().orElse(null);
        Map aggregatedDataSources = new RuleMetaData(builtRules).findAttribute(AggregatedDataSourceRuleAttribute.class).map(AggregatedDataSourceRuleAttribute::getAggregatedDataSources).orElseGet(() -> PhysicalDataSourceAggregator.getAggregatedDataSources((Map)dataSources, (Collection)builtRules));
        this.dataSourceNames = new CaseInsensitiveSet(aggregatedDataSources.keySet());
        this.protocolType = protocolType;
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseName, protocolType, aggregatedDataSources, builtRules, (Collection<String>)this.configuration.getTables());
        SingleTableMapperRuleAttribute tableMapperRuleAttribute = new SingleTableMapperRuleAttribute(this.singleTableDataNodes.values());
        this.mutableDataNodeRuleAttribute = new SingleMutableDataNodeRuleAttribute(this.configuration, this.dataSourceNames, this.singleTableDataNodes, protocolType, tableMapperRuleAttribute);
        this.attributes = new RuleAttributes(new RuleAttribute[]{new SingleDataNodeRuleAttribute(this.singleTableDataNodes), tableMapperRuleAttribute, new SingleExportableRuleAttribute(tableMapperRuleAttribute), this.mutableDataNodeRuleAttribute, new AggregatedDataSourceRuleAttribute(aggregatedDataSources)});
    }

    public String assignNewDataSourceName() {
        return null == this.defaultDataSource ? new ArrayList<String>(this.dataSourceNames).get(ThreadLocalRandom.current().nextInt(this.dataSourceNames.size())) : this.defaultDataSource;
    }

    public boolean isAllTablesInSameComputeNode(Collection<DataNode> dataNodes, Collection<QualifiedTable> singleTables) {
        if (!this.isSingleTablesInSameComputeNode(singleTables)) {
            return false;
        }
        QualifiedTable sampleTable = singleTables.iterator().next();
        Optional<DataNode> sampleDataNode = this.mutableDataNodeRuleAttribute.findTableDataNode(sampleTable.getSchemaName(), sampleTable.getTableName());
        if (sampleDataNode.isPresent()) {
            for (DataNode each : dataNodes) {
                if (this.isSameComputeNode(sampleDataNode.get().getDataSourceName(), each.getDataSourceName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameComputeNode(String sampleDataSourceName, String dataSourceName) {
        return sampleDataSourceName.equalsIgnoreCase(dataSourceName);
    }

    private boolean isSingleTablesInSameComputeNode(Collection<QualifiedTable> singleTables) {
        String sampleDataSourceName = null;
        for (QualifiedTable each : singleTables) {
            Optional<DataNode> dataNode = this.mutableDataNodeRuleAttribute.findTableDataNode(each.getSchemaName(), each.getTableName());
            if (!dataNode.isPresent()) continue;
            if (null == sampleDataSourceName) {
                sampleDataSourceName = dataNode.get().getDataSourceName();
                continue;
            }
            if (this.isSameComputeNode(sampleDataSourceName, dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public Collection<QualifiedTable> getSingleTables(Collection<QualifiedTable> qualifiedTables) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        for (QualifiedTable each : qualifiedTables) {
            Collection dataNodes = this.singleTableDataNodes.getOrDefault(each.getTableName().toLowerCase(), new LinkedList());
            if (dataNodes.isEmpty() || !this.containsDataNode(each, dataNodes)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean containsDataNode(QualifiedTable qualifiedTable, Collection<DataNode> dataNodes) {
        for (DataNode each : dataNodes) {
            if (!qualifiedTable.getSchemaName().equalsIgnoreCase(each.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    public Collection<QualifiedTable> getQualifiedTables(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        Collection<Object> tables = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables() : Collections.emptyList();
        Collection result = this.getQualifiedTables(database, this.protocolType, tables);
        if (result.isEmpty() && sqlStatementContext instanceof IndexAvailable) {
            result = IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)this.protocolType, (Collection)((IndexAvailable)sqlStatementContext).getIndexes());
        }
        return result;
    }

    private Collection<QualifiedTable> getQualifiedTables(ShardingSphereDatabase database, DatabaseType databaseType, Collection<SimpleTableSegment> tableSegments) {
        ArrayList<QualifiedTable> result = new ArrayList<QualifiedTable>(tableSegments.size());
        String schemaName = new DatabaseTypeRegistry(databaseType).getDefaultSchemaName(database.getName());
        for (SimpleTableSegment each : tableSegments) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(schemaName);
            result.add(new QualifiedTable(actualSchemaName, each.getTableName().getIdentifier().getValue()));
        }
        return result;
    }

    public int getOrder() {
        return 5;
    }

    @Generated
    public SingleRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

