/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionValues;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;

public final class EncryptPredicateParameterRewriter
implements ParameterRewriter {
    private final EncryptRule rule;
    private final String databaseName;
    private final Collection<EncryptCondition> encryptConditions;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty()) {
            return true;
        }
        if (sqlStatementContext instanceof SelectStatementContext) {
            return this.isSubqueryNeedRewrite((SelectStatementContext)sqlStatementContext);
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            return this.isSubqueryNeedRewrite(((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext());
        }
        return false;
    }

    private boolean isSubqueryNeedRewrite(SelectStatementContext selectStatementContext) {
        for (SelectStatementContext each : selectStatementContext.getSubqueryContexts().values()) {
            if (!this.isNeedRewrite((SQLStatementContext)each)) continue;
            return true;
        }
        return false;
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        String schemaName = ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (EncryptCondition each : this.encryptConditions) {
            this.encryptParameters(paramBuilder, each.getPositionIndexMap(), this.getEncryptedValues(schemaName, each, new EncryptConditionValues(each).get(params)));
        }
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getColumnSegment().getColumnBoundInfo().getOriginalTable().getValue();
        String columnName = encryptCondition.getColumnSegment().getIdentifier().getValue();
        EncryptTable encryptTable = this.rule.getEncryptTable(tableName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        if (encryptCondition instanceof EncryptBinaryCondition && "LIKE".equals(((EncryptBinaryCondition)encryptCondition).getOperator()) && encryptColumn.getLikeQuery().isPresent()) {
            return encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues);
        }
        return encryptColumn.getAssistedQuery().isPresent() ? encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues) : encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues);
    }

    private void encryptParameters(ParameterBuilder paramBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)paramBuilder).addReplacedParameters(entry.getValue().intValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Generated
    public EncryptPredicateParameterRewriter(EncryptRule rule, String databaseName, Collection<EncryptCondition> encryptConditions) {
        this.rule = rule;
        this.databaseName = databaseName;
        this.encryptConditions = encryptConditions;
    }
}

