/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.engine.type.DALStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DCLStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DDLStatementBindEngine;
import org.apache.shardingsphere.infra.binder.engine.type.DMLStatementBindEngine;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;

public final class SQLBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final HintValueContext hintValueContext;

    public SQLStatementContext bind(SQLStatement sqlStatement, List<Object> params) {
        SQLStatement boundSQLStatement = this.isNeedBind() ? this.bindSQLStatement(sqlStatement) : sqlStatement;
        return SQLStatementContextFactory.newInstance(this.metaData, boundSQLStatement, params, this.currentDatabaseName);
    }

    private boolean isNeedBind() {
        return !this.hintValueContext.findHintDataSourceName().isPresent() && !HintManager.getDataSourceName().isPresent();
    }

    private SQLStatement bindSQLStatement(SQLStatement statement) {
        if (statement instanceof DMLStatement) {
            return new DMLStatementBindEngine(this.metaData, this.currentDatabaseName, this.hintValueContext).bind((DMLStatement)statement);
        }
        if (statement instanceof DDLStatement) {
            return new DDLStatementBindEngine(this.metaData, this.currentDatabaseName, this.hintValueContext).bind((DDLStatement)statement);
        }
        if (statement instanceof DALStatement) {
            return new DALStatementBindEngine(this.metaData, this.currentDatabaseName, this.hintValueContext).bind((DALStatement)statement);
        }
        if (statement instanceof DCLStatement) {
            return new DCLStatementBindEngine(this.metaData, this.currentDatabaseName, this.hintValueContext).bind((DCLStatement)statement);
        }
        return statement;
    }

    @Generated
    public SQLBindEngine(ShardingSphereMetaData metaData, String currentDatabaseName, HintValueContext hintValueContext) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.hintValueContext = hintValueContext;
    }
}

